<?php

namespace App\Http\Requests\Dashboard;

use App\Models\Phase;
use Illuminate\Foundation\Http\FormRequest;

class PostSecurityRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if ($this->has("post_security_id") && !is_null($this->request->get("post_security_id"))) {
            return auth()->user()->hasPermission("edit_post_securities");
        }

        return auth()->user()->hasPermission("create_post_securities");
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "role_id_to_be_reviewed" => "required|exists:roles,id",
            "phase_ids" => [
                "required",
                function($attribute, $value, $fail) {
                    $phases = explode(",", $value);
                    foreach ($phases as $phase) {
                        if(is_null(Phase::find($phase))) {
                            $fail("Error occurred. Please try again!");
                        }
                    }
                }
            ],
        ];
    }

    public function attributes()
    {
        return [
            "phase_ids" => "phases"
        ];
    }
}
