<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PostSecurity extends Model
{
    protected $table = "post_securities";

    protected $fillable = [
        "role_id", "phases_id"
    ];

    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function phases($onlyNames = false)
    {
        $collection = collect();
        $names = [];
        $phase_ids = explode(",", $this->phase_ids);

        foreach ($phase_ids as $phase_id) {
            $phase = Phase::findOrFail($phase_id);
            array_push($names, $phase->name);
            $collection->push($phase);
        }

        if ($onlyNames) return implode(", ", $names);

        return $collection;
    }

    public function getPhasesAttribute()
    {
        return $this->phases();
    }

    public function getPhaseNamesAttribute()
    {
        return $this->phases(true);
    }

    public function hasNextPhase($id)
    {
        return in_array($id + 1, explode(",", $this->phases_id));
    }
}
