<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePostReviewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('post_reviews', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('post_id')->unsigned();
            $table->unsignedBigInteger('post_security_id');
            $table->integer('current_phase');
            $table->boolean('is_passed_all_phases')->default(false);

            $table->foreign("post_id")
                ->references("id")
                ->on("posts")
                ->onDelete("cascade");

            $table->foreign("post_security_id")
                ->references("id")
                ->on("post_securities")
                ->onDelete("cascade");

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('post_reviews');
    }
}
