<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Phase extends Model
{
    protected $table = "phases";
    protected $fillable = [
        "name", "reviewer_role_id"
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function reviewer()
    {
        return $this->belongsTo(Role::class, "reviewer_role_id");
    }
}
