<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    protected $table = "post_reviews";

    public function post()
    {
        return $this->belongsTo(Post::class);
    }

    public function postSecurity()
    {
        return $this->belongsTo(PostSecurity::class, "post_security_id");
    }

    public function getPhase()
    {
        return $this->postSecurity->phases()->where("id", $this->current_phase)->first();
    }

    public function canReview()
    {
        return $this->getPhase()->reviewer_role_id == auth()->user()->role->id;
    }

    public function getCurrentReviewer()
    {
        return $this->getPhase()->reviewer;
    }
}
