<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\Post;
use App\Models\User;
use App\Models\Comment;
use App\Http\Controllers\Controller;

class IndexController extends Controller
{
    public function index()
    {
        $comments = collect();


        if (auth()->user()->hasPermission("approve_all_comments")) {
            $comments = Comment::where("is_active", false)->get();
        } else {

            $posts = Post::all();
            foreach ($posts as $post) {
                if ($post->user_id == auth()->user()->id) {
                    foreach ($post->comment as $comment) {
                        if (!$comment->is_active) {
                            $comments->push($comment);
                        }
                    }
                }
            }

            $comments = $comments->flatten();
        }

        $counters = array(
            "allPosts" => Post::count(),
            "currentUserPosts" => Post::where("user_id", auth()->user()->id)->count(),
            "users" => !is_null(auth()->user()->company) ? auth()->user()->company->users->count() : User::count(),
            "total_comments" => Comment::count(),
            "comments" => auth()->user()->comments->count()
        );

        return view("dashboard.index")->with([
            "counters" => $counters,
            "pendingPosts" => Post::where("is_confirmed", false)->get(),
            "pendingComments" => $comments,
            "mostLikedPosts" => Post::where("total_likes", ">=", 1)->orderBy("total_likes", "desc")->take(10)->get(),
        ]);
    }
}
