<?php

namespace App\Models;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class UserProfile extends Model
{
    protected $table = "user_profiles";

    protected $fillable = [
        "technoblog_email",
        "user_id",
        "is_company_profile",
        "profile_link",
        "short_bio",
        "profile_photo_link",
        "cover_photo_link",
        "technoblog_email",
        "facebook_link",
        "instagram_link",
        "twitter_link",
        "skype_link",
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }
}
