var app = {

    // Initialize
    init: function() {
        this.showCompanyModal();
        this.welcomeSlider();
        this.categoryNavbarPosition();
        this.categoryNavbarActiveLink();
        this.buildSimpleTooltip();
        this.scrollSmoothly();
        this.scrollToTop();
        this.likePost();
        this.unlikePost();
        this.comment();
    },

    showCompanyModal: function() {
        if($(".company-modal").length) {
            setTimeout(function () {
                $(".company-modal").modal("show");
            }, 2000);
        }
    },

    welcomeSlider: function() {
        var swiper = new Swiper('.swiper-container', {
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
                renderBullet: function(index, className) {
                    return '<span class="' + className + '">' + (index + 1) + '</span>';
                },
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            loop: true,
            centeredSlides: true,
            autoplay: {
                delay: 2500,
                disableOnInteraction: false,
            },
        });
    },

    categoryNavbarPosition: function() {
        if ($(".categoryNavbar").length) {
            var distance = $(".navbar").offset().top;
            var $window = $(window);
            var navbar = $(".navbar");

            $window.scroll(function() {
                if ($window.scrollTop() >= distance) {
                    navbar.addClass("fixed-top");
                } else {
                    navbar.removeClass("fixed-top");
                }
            });
        }
    },

    categoryNavbarActiveLink: function() {
        if ($(".categoryNavbar").length) {
            $(".categoryNavbar a[href='http://technoblog.test/category/" + window.location.pathname + "']").addClass("active");
        }
    },

    buildSimpleTooltip: function() {
        if (!$("a.elemWithTooltip").length || !$("a.elemWithTooltip").data("tooltip-info")) {
            return false;
        }

        var tooltipElem = $("a.elemWithTooltip");
        var placements = ["top", "right", "bottom", "left"];

        tooltipElem.each(function(i) {

            var $this = $(this);
            var tooltipData = $this.data("tooltip-info");
            var title = tooltipData.substring(tooltipData.indexOf("-") + 1);
            var placement = tooltipData.substring(0, tooltipData.indexOf("-"));

            if (tooltipData.indexOf("-") === -1 || tooltipData.charAt(0) === "-") {
                $this.addClass("Error_SimpleTooltip");
                return false;
            }

            $.each(placements, function(j) {
                if (placement === placements[j]) {
                    $this.not(".Error_SimpleTooltip").attr({
                        "data-toggle": "tooltip",
                        "data-placement": placement,
                        "title": title
                    }).tooltip();
                }
            });
        });

    },

    scrollSmoothly: function() {
        var scroll = new SmoothScroll("a.scrollBtn", {
            easing: "linear"
        });
    },

    scrollToTop: function() {
        if ($(".scrollUpArrow").length) {
            var distance = 150;
            var $window = $(window);
            var scrollUp = $(".scrollUpArrow");

            scrollUp.hide();

            $window.scroll(function() {
                if ($window.scrollTop() >= distance) {
                    scrollUp.fadeIn("slow");
                } else {
                    scrollUp.fadeOut("slow");
                }
            });
        }
    },

    likePost: function() {

        $(".post-reaction").on("click", ".likePost", function() {

            var data = $(this).data("post-id");
            var _token = $("meta[name='csrf-token']").attr("content");

            $.ajax({
                url: "/like",
                type: "post",
                data: {
                    post_id : data,
                    _token : _token,
                },
                dataType: "json",
                success: function(response) {
                    $(".post-reaction i").remove();
                    $(".post-reaction").append("<i data-unlike-id=" + response.unlike_id + " class='text-danger fa fa-heart unlikePost' aria-hidden='true'></i>");
                    $(".likeCounter").text(response.likeCounter);
                },
                error: function(data) {
                    console.log(data);
                }
            });
        })
    },

    unlikePost: function() {

        $(".post-reaction").on("click", ".unlikePost", function() {

            var data = $(this).data("unlike-id");
            var _token = $("meta[name='csrf-token']").attr("content");

            $.ajax({
                url: "/unlike",
                type: "post",
                data: {
                    unlike_id : data,
                    _token : _token,
                },
                dataType: "json",
                success: function(response) {
                    $(".post-reaction i").remove();
                    $(".post-reaction").append("<i data-post-id=" + response.post_id + " class='text-danger fa fa-heart-o likePost' aria-hidden='true'></i>");
                    $(".likeCounter").text(response.likeCounter);
                },
                error: function(data) {
                    console.log(data);
                }
            });
        })
    },

    comment: function() {

        if($("comment-alert").length > 0) {
            $(".comment-alert").hide();
        }

        $(".commentForm").submit(function(e) {

            e.preventDefault();

            $(this).find("input[type='submit']").prop("disabled", true);
            $(this).find("input[type='submit']").val("Processing...");

            var name = $(this).find("input[name='name']").val();
            var email = $(this).find("input[name='email']").val();
            var comment = $(this).find("textarea[name='comment']").val();
            var post_id = $(this).find("input[name='post_id']").val();
            var _token = $("meta[name='csrf-token']").attr("content");

            $.ajax({
                url: "/comment",
                type: "post",
                data: {
                    name: name,
                    email: email,
                    comment: comment,
                    post_id: post_id,
                    _token : _token,
                },
                dataType: "json",
                success: function(response) {

                    $(".comment-alert").show();
                    $(".comment-alert").addClass(response.type);
                    $(".comment-alert").find("strong").text(response.message);

                    $(".commentForm").find("input[type='submit']").prop("disabled", false);
                    $(".commentForm").find("input[type='submit']").val("Comment");
                    $(".commentForm")[0].reset();
                },
                error: function(data) {
                    console.log(data);
                }
            });
        });
    }

};

$(function() {
    app.init();
});
