@extends("layouts.dashboard")

@section("title", "Add new user - Dashboard | TechnoBlog")

@section("dashboard_content")

    <div class="my-3 my-md-5">

        <div class="container">

            <div class="row">

                <div class="col-sm-12">

                    <form class="card actionForm" action="{{ route("dashboard.users.store") }}" method="post" accept-charset="utf-8">

                        @csrf
                        <input type="hidden" name="company_id" value="{{ $company->id }}">
                        <input type="hidden" name="company_owner" value="true">

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb" style="border-radius: 0px !important;">
                                <li class="breadcrumb-item">
                                    <a href="{{ route("dashboard.index") }}">Dashboard</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route("dashboard.users.index") }}">Users</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Add New</li>
                            </ol>
                        </nav>

                        <div class="card-body">

                            <h3 class="card-title border-bottom pb-4">Add new User</h3>

                            <div class="row">

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">Name</label>
                                        <input type="text" name="name" value="{{ old('name', $company->name) }}" class="form-control" placeholder="Name" required>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">Surname</label>
                                        <input type="text" name="surname" value="{{ old('surname', 'Admin') }}" class="form-control" placeholder="Surname" required>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">E-mail</label>
                                        <input type="email" name="email" value="{{ old('email', $company->email) }}" class="form-control" placeholder="E-mail" required>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">Mobile Number Country Code</label>
                                        <select class="selectData" id="selectWithContent" name="mobile_number_country">
                                            <option value=""></option>
                                            @foreach ($countries as $code => $name)
                                                <option value="{{ $code }}" {{ (old("mobile_number_country") == $code) ? "selected" : "" }} data-data='{"image": "/assets/images/flags/{{ strtolower($code) }}.svg"}'>{{ $name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">Mobile Number</label>
                                        <input type="text" name="mobile_number" value="{{ old('mobile_number') }}" class="form-control" placeholder="Phone number" autocomplete="off" required>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">Username</label>
                                        <input type="text" name="username" value="{{ old('username', strtolower($company->name) . 'admin') }}" class="form-control" placeholder="Username" required>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">User Role</label>
                                        <select class="selectData">
                                            <option value="1" disabled selected>Admin</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="card-footer text-right">
                            <input type="submit" value="Create User" class="submitBtn btn btn-primary">
                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

@endsection
