<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', "Blog\BlogController@index")->name("blog.index");
Route::get('/about', "Blog\BlogController@about")->name("blog.about");
Route::get('/category/{category}', "Blog\BlogController@showCategory")->name("blog.category");
Route::get('/category/{category}/{slug}', "Blog\BlogController@showPost")->name("blog.post");
Route::get("/profile/{profileLink}", "Blog\BlogController@showProfile")->name("blog.user-profile");
Route::get("/tag/{tag}", "Blog\BlogController@showTagPosts")->name("blog.tag");
Route::get("/search", "Blog\SearchController@search")->name("blog.search");

Route::post("/company/store", "Blog\BlogController@storeCompany")->name("blog.company.store");

Route::post("/comment", "Blog\BlogController@comment")->name("blog.comment");
Route::post("/like", "Blog\BlogController@like")->name("blog.like");
Route::post("/unlike", "Blog\BlogController@unlike")->name("blog.unlike");

////////////////////
// Auth Routes
////////////////////
Route::prefix('auth')->group(function () {

    Route::get('/login', "Auth\LoginController@showLogin")->name("auth.loginShow");
    Route::post('/login', "Auth\LoginController@login")->name("auth.login");
    Route::post('/logout', "Auth\LoginController@logout")->name("auth.logout");

    Route::get('/forgot', "Auth\ForgotPasswordController@showForgotPassword")->name("auth.forgotShow");
    Route::post('/forgot', "Auth\ForgotPasswordController@forgotPassword")->name("auth.forgot");

    Route::group(['middleware' => "createPassword"], function () {
        Route::get('/create-password/{id}/{token}', "Auth\CreatePasswordController@showCreatePassword")->name("auth.create-password-show");
        Route::post('/create-password/{id}/{token}', "Auth\CreatePasswordController@createPassword")->name("auth.create-password");
    });

    Route::group(['middleware' => "checkVerifyNewEmail"], function () {
        Route::get('/verify/{id}/{token}', "Auth\VerifyNewEmailController@create")->name("auth.verifyShow");
        Route::post('/verify/{id}/{token}', "Auth\VerifyNewEmailController@verify")->name("auth.verify");
    });

});

////////////////////
// Dashboard Routes
////////////////////

Route::group(['prefix' => 'dashboard', 'middleware' => ["auth", "checkIsActive"]], function () {

    Route::get("/", "Dashboard\IndexController@index")->name("dashboard.index");

    // Settings
    Route::get("/settings", "Dashboard\SettingsController@settings")->name("dashboard.settings.index");
    Route::patch("/settings/personal", "Dashboard\SettingsController@updatePersonalInformation")->name("dashboard.settings.personal");
    Route::patch("/settings/photos", "Dashboard\SettingsController@updatePhotos")->name("dashboard.settings.photos");
    Route::patch("/settings/social", "Dashboard\SettingsController@updateSocialLinks")->name("dashboard.settings.social");
    Route::patch("/settings/username", "Dashboard\SettingsController@updateUsername")->name("dashboard.settings.username");
    Route::patch("/settings/password", "Dashboard\SettingsController@updatePassword")->name("dashboard.settings.password");
    Route::patch("/settings/email", "Dashboard\SettingsController@updateEmail")->name("dashboard.settings.email");
    Route::post("/settings/transfer/", "Dashboard\SettingsController@transferPostsAndDeleteUser")->name("dashboard.settings.transfer");

    // Settings => Phases
    Route::post("/settings/phase/store", "Dashboard\SettingsController@phaseStore")->name("dashboard.settings.phase.store");
    Route::delete("/settings/phase/{id}", "Dashboard\SettingsController@phaseDestroy")
        ->name("dashboard.settings.phase.destroy")
        ->middleware("permission:delete_phase");

    // Settings => Post Security
    Route::post("/settings/post-security/store", "Dashboard\SettingsController@postSecurityStore")->name("dashboard.settings.post-security.store");
    Route::delete("/settings/post-security/{id}", "Dashboard\SettingsController@postSecurityDestroy")
        ->name("dashboard.settings.post-security.destroy")
        ->middleware("permission:delete_post_securities");

    // Users
    Route::group(['middleware' => 'permission:access_all_users'], function () {
        Route::get("/users", "Dashboard\UsersController@index")->name("dashboard.users.index");
        Route::patch("/users/{id}/block", "Dashboard\UsersController@block")->name("dashboard.users.block");
        Route::patch("/users/{id}/unblock", "Dashboard\UsersController@unblock")->name("dashboard.users.unblock");
        Route::delete("/users/{id}/destroy", "Dashboard\UsersController@destroy")->name("dashboard.users.destroy");
    });

    Route::group(['middleware' => 'permission:create_user'], function () {
        Route::get("/users/create", "Dashboard\UsersController@create")->name("dashboard.users.create");
        Route::post("/users/store", "Dashboard\UsersController@store")->name("dashboard.users.store");
    });

    // Posts
    Route::get("/posts", "Dashboard\PostsController@index")->name("dashboard.posts.index");
    Route::get("/posts/create", "Dashboard\PostsController@create")->name("dashboard.posts.create");
    Route::post("/posts/store", "Dashboard\PostsController@store")->name("dashboard.posts.store");
    Route::get("/posts/{id}/edit", "Dashboard\PostsController@editShow")->name("dashboard.posts.editShow");
    Route::patch("/posts/{id}/edit", "Dashboard\PostsController@edit")->name("dashboard.posts.edit");
    Route::patch("/posts/{id}/block", "Dashboard\PostsController@block")->name("dashboard.posts.block");
    Route::patch("/posts/{id}/unblock", "Dashboard\PostsController@unblock")->name("dashboard.posts.unblock");
    Route::patch("/posts/{id}/confirm", "Dashboard\PostsController@confirm")->name("dashboard.posts.confirm");
    Route::delete("/posts/{id}/destroy", "Dashboard\PostsController@destroy")->name("dashboard.posts.destroy");

    // Categories
    Route::group(['middleware' => 'permission:access_all_categories'], function () {
        Route::get("/categories", "Dashboard\CategoriesController@index")->name("dashboard.categories.index");
        Route::get("/categories/create", "Dashboard\CategoriesController@create")->name("dashboard.categories.create");
        Route::post("/categories/store", "Dashboard\CategoriesController@store")->name("dashboard.categories.store");
        Route::get("/categories/{id}/edit", "Dashboard\CategoriesController@editShow")->name("dashboard.categories.editShow");
        Route::patch("/categories/{id}/edit", "Dashboard\CategoriesController@edit")->name("dashboard.categories.edit");
        Route::patch("/categories/{id}/block", "Dashboard\CategoriesController@block")->name("dashboard.categories.block");
        Route::patch("/categories/{id}/unblock", "Dashboard\CategoriesController@unblock")->name("dashboard.categories.unblock");
        Route::delete("/categories/{id}/destroy", "Dashboard\CategoriesController@destroy")->name("dashboard.categories.destroy");
    });

    // Comments
    Route::get("/comments", "Dashboard\CommentsController@index")->name("dashboard.comments.index");
    Route::patch("/comments/{id}/confirm", "Dashboard\CommentsController@confirm")->name("dashboard.comments.confirm");
    Route::delete("/comments/{id}/destroy", "Dashboard\CommentsController@destroy")->name("dashboard.comments.destroy");

    // Tags
    Route::get("/tags", "Dashboard\TagsController@index")->name("dashboard.tags.index");
    Route::delete("/tags/{id}/destroy", "Dashboard\TagsController@destroy")->name("dashboard.tags.destroy");

    // Companies
    Route::get("/companies", "Dashboard\CompaniesController@index")->name("dashboard.companies.index");
    Route::get("/companies/{id}/create-admin/", "Dashboard\CompaniesController@createAdmin")->name("dashboard.companies.create-admin");
    Route::post("/companies/store-admin", "Dashboard\CompaniesController@storeAdmin")->name("dashboard.companies.store-admin");
    Route::delete("/companies/{id}/destroy", "Dashboard\CompaniesController@destroy")->name("dashboard.companies.destroy");

    // Notifications
    Route::get("/notifications", "Dashboard\NotificationsController@notifications")->name("dashboard.notifications.index");
    Route::post("/get-notifications", "Dashboard\NotificationsController@showNotifications")->name("dashboard.notifications.store");
});
