<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;
use Propaganistas\LaravelPhone\PhoneNumber;

class NewUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            "name" => "required|alpha|min:2|max:255",
            "surname" => "required|alpha|min:2|max:255",
            "mobile_number_country" => "required_with:mobile_number|string|size:2",
            "mobile_number" => "phone:mobile_number_country|unique:users,mobile_number",
            "email" => "required|string|email|max:255|unique:users",
            "username" => "required|alpha_dash|min:8|unique:users,username",
        ];

        if (!$this->has("company_id")) {
            $rules["userRole"] = "required|exists:roles,id";
        }

        return $rules;
    }

    protected function getValidatorInstance()
    {
        try {
            if($this->request->has("mobile_number") && $this->request->has("mobile_number_country")) {
                $this->request->set("mobile_number", PhoneNumber::make(
                    $this->request->get("mobile_number"),
                    $this->request->get("mobile_number_country")
                )->formatInternational());
            }
        } catch (\Exception $e) {}

        return parent::getValidatorInstance();
    }
}
