@extends("layouts.dashboard")

@section("title", "Companies - Dashboard | TechnoBlog")

@section("dashboard_content")

    <div class="my-3 my-md-5">

        <div class="container">

            <div class="page-header">
                <h1 class="page-title">Companies</h1>
            </div>

            <div class="row">

                <div class="col-sm-12">
                    <div class="card">

                        <div class="card-header">
                            <h3 class="card-title">List of tags</h3>
                        </div>

                        <div class="table-responsive pt-5 pb-5">

                            <table id="dttable" class="table" style="width:100%">
                                <thead>
                                <tr>
                                    <th class="text-center">Name</th>
                                    <th class="text-center">Website</th>
                                    <th class="text-center">E-mail</th>
                                    <th class="text-center">Users</th>
                                    <th class="text-center">Created Date</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($companies as $company)
                                    <tr>
                                        <td>{{ $company->name }}</td>
                                        <td><a href="{{ $company->website }}" target="_blank">{{ $company->website }}</a></td>
                                        <td>{{ $company->email }}</td>
                                        <td>{{ $company->users->count() }}</td>
                                        <td>{{ date('d.m.Y', strtotime($company->created_at)) }}</td>
                                        <td class="text-center">
                                            <div class="item-action dropdown">
                                                <a href="javascript:void(0)" data-toggle="dropdown" class="icon" aria-expanded="false"><i class="fe fe-more-vertical"></i></a>
                                                <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; transform: translate3d(15px, 20px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                    @if(!$company->users->count())
                                                        <a href="{{ route("dashboard.companies.create-admin", ["id" => $company->id]) }}" class="actionLink dropdown-item" style="cursor: pointer;"><i class="dropdown-icon fe fe-user"></i> Create admin user</a>
                                                    @endif
                                                    <a href="javascript:void(0)" class="actionLink dropdown-item" style="cursor: pointer;" data-action="{{ route("dashboard.tags.destroy", ["id" => $company->id]) }}" data-method="delete"><i class="dropdown-icon fe fe-trash-2 text-danger"></i> Delete </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

@endsection
