<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CompaniesController extends Controller
{
    public function index()
    {
        return view("dashboard.companies.index")->with([
            "companies" => Company::all()
        ]);
    }

    public function createAdmin($id)
    {
        $company = Company::findOrFail($id);

        if($company->users->count()) {
            return redirect()->route("dashboard.companies.index");
        }

        return view("dashboard.companies.create-admin")->with([
            "company" => $company,
            "countries" => country()->all()
        ]);
    }

    public function destroy($id)
    {
        $company = Company::findOrFail($id);
        $companyName = $company->name;
        $company->delete();

        Alert::flash($companyName . " deleted successfully");

        return redirect()->route("dashboard.companies.index");
    }
}
