import React from "react";

import axios from "../../../axios.js";
import { Navigate, useAsyncValue, useNavigate } from "react-router-dom";
import LoginForm from "../../Login/LoginForm.js";
import {useAuth} from "../../Context/AuthContext";

const useLogin = () => {

    const navigator = useNavigate()
	const Auth = useAuth();
    //const history = useNavigate();
    const login = async (loginData) => {
		console.log({loginData})
		console.log(loginData)
        await axios
	            .post(`/api/login`, {
                    username: loginData.email,
                    password: loginData.password
                }, {
                    headers: { 
                        "Content-Type": "application/x-www-form-urlencoded"
                    }
                }) 
	            .then((res) => {
					console.log("RES LOGIN")
					console.log(res)
					if(res.status === 200)
					{
						const user = {
							sessionId: res.data.auth.details.sessionId,
							userId: res.data.auth.principal.userID,
							username: res.data.auth.principal.username,
							role: res.data.auth.principal.role,
							name: res.data.auth.principal.name,
							surname: res.data.auth.principal.surname,
						}
						Auth.userLogin(user);
						console.log(user)
					}
					const sessionId = res.data.auth.details.sessionId;
					const userId = res.data.auth.principal.userID;

					localStorage.setItem("sessionId", sessionId);
					localStorage.setItem("userId", userId);
					if(sessionId === null)
					{
					}
                    navigator("/home")
	            })
	            .catch((err) => {
	                console.log(err);
	            })
	            .finally(() => {
	            });
    }

	return {
		login
	};

}

export default useLogin;