import React from "react";
import Dropdown from 'react-bootstrap/Dropdown';
import { BsSortUp } from "react-icons/bs"

const SortButton = (props) => {
    return (
        <Dropdown onSelect={(event, x) => {
            console.log(event)
            props.setSortingArg(event)
        }}>
          <Dropdown.Toggle variant="success" id="dropdown-basic" size="lg">
          <span className="ikona my-1"><BsSortUp/></span>
              <span className="ikona mx-3">Сортирај</span>
          </Dropdown.Toggle>
    
          <Dropdown.Menu >
              {props.type !== 'restaurant' && <Dropdown.Item eventKey={'priceDesc'}>Цена растечки</Dropdown.Item>}
              {props.type !== 'restaurant' && <Dropdown.Item eventKey={'priceAsc'}>Цена опаѓачки</Dropdown.Item>}
              {props.type !== 'transport' && <Dropdown.Item eventKey={'nameAsc'}>Име растечки</Dropdown.Item>}
              {props.type !== 'transport' && <Dropdown.Item eventKey={'nameDesc'}>Име опаѓачки</Dropdown.Item>}
          </Dropdown.Menu>
        </Dropdown>
      );
}


  export default SortButton;