import {Button, Col, Container, Image, Modal, Row} from "react-bootstrap";
import {FaCalendarAlt} from "react-icons/fa";
import {MdBalcony, MdLocationOn} from "react-icons/md";
import {LuFan} from "react-icons/lu";
import {TbToolsKitchen2} from "react-icons/tb";
import React from "react";
import useCreate from "../Hooks/useCreate";

const HotelReservationModal = (props) => {

    const {createEntity} = useCreate();

    const dateFormatter = (str) => {
        const inputDate = new Date(str);

        const options = {
            year: 'numeric',
            month: '2-digit',
            day: '2-digit',
            hour12: false,
        };

        console.log(props)

        return inputDate.toLocaleString('de-DE', options);

    }

    return (
        <>
            <Modal size={"xl"} show={props.show} onHide={props.handleClose}>
                <Modal.Header closeButton>
                    <Modal.Title>Детали за резервација</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <Container className="py-3 px-1 my-4" style={{maxWidth: "90%"}}>
                        <Row className={'mb-3'}>
                            <Col className={'px-4'}>
                                <h3>{props.data.hotelName}</h3>
                            </Col>
                            <Col>

                            </Col>
                        </Row>
                        <Row className={'mb-3'}>
                            <Col className={'d-flex flex-column justify-content-between'}>
                                <Row>
                                    <Col md={'auto'}
                                         className={'d-flex flex-column justify-content-center align-items-center ms-3'}>
                                        <FaCalendarAlt size={'2em'}/>
                                    </Col>
                                    <Col md={'auto'} style={{borderRight: '1px solid black'}}>
                                        <Row className={'w-75'}>
                                            <h6>Пријавување</h6>
                                        </Row>
                                        <Row>
                                            <h5>{dateFormatter(props.data.dateFrom)}</h5>
                                        </Row>

                                    </Col>
                                    <Col>
                                        <Row>
                                            <h6>Одјавување</h6>
                                        </Row>
                                        <Row>
                                            <h5>{dateFormatter(props.data.dateTo)}</h5>
                                        </Row>
                                    </Col>
                                    <Col md={7}>

                                    </Col>
                                </Row>
                                <Row>
                                    <Col md={'auto'}
                                         className={'d-flex flex-column justify-content-center align-items-center ms-3'}>
                                        <MdLocationOn size={'2em'}/>
                                    </Col>
                                    <Col md={'auto'}>
                                        <Row className={'w-75'}>
                                            <h6>Адреса</h6>
                                        </Row>
                                        <Row>
                                            <h5>ул. Македонска бр. 10</h5>
                                        </Row>
                                    </Col>
                                    <Col>
                                    </Col>

                                </Row>
                            </Col>
                            <Col className={'d-flex flex-column align-items-center'}>
                                <Image
                                    src="https://www.imgacademy.com/sites/default/files/legacyhotel.jpg"
                                    style={{
                                        height: "10em",
                                        borderRadius: "1em",
                                        boxShadow: "0 4px 20px lightblue",
                                        maxWidth: "100%",
                                    }}
                                ></Image>
                            </Col>

                        </Row>
                    </Container>
                    <Container>
                        <Row className={'mb-3'}>
                            <h4>Детали за собата</h4>
                        </Row>
                        <Row>
                            <Col className="d-flex justify-content-center">
                                <Image
                                    src="https://img.freepik.com/free-photo/luxury-classic-modern-bedroom-suite-hotel_105762-1787.jpg?w=200"
                                    style={{
                                        height: "10em",
                                        borderRadius: "1em",
                                        boxShadow: "0 4px 20px lightblue",
                                        maxWidth: "100%",
                                    }}
                                ></Image>
                            </Col>
                            <Col className="d-flex flex-column justify-content-center" style={{textAlign: "left"}}>
                                <Row><h4>{props.data.hotelRoom.hotelRoomName}</h4></Row>
                                <Row>
                                    {props.data.hotelRoom.airConditioning && <Col className="col-auto">
                                        <Container className="py-1 px-1">
                                            <Row className="d-flex flex-row">
                                                <Col className="m-0 w-25 py-1">
                                                    <LuFan
                                                        className="my-0 "
                                                        color="#159895"
                                                        size={40}
                                                    ></LuFan>
                                                </Col>
                                                <Col className="w-75 d-flex p-0">
                                                    <h6 style={{fontSize: "14px"}} className="m-auto">
                                                        Климатизирано
                                                    </h6>
                                                </Col>
                                            </Row>
                                        </Container>
                                    </Col>}
                                    {props.data.hotelRoom.kitchenAvailable && <Col className="col-auto">
                                        <Container
                                            className="py-1 px-1">
                                            <Row className="d-flex flex-row">
                                                <Col className="m-0 w-25 py-1">
                                                    <TbToolsKitchen2 className="my-0 " color="#159895"
                                                                     size={40}></TbToolsKitchen2>
                                                </Col>
                                                <Col className="w-75 d-flex p-0">
                                                    <h6 style={{fontSize: "14px"}} className="m-auto">Кујна</h6>
                                                </Col>
                                            </Row>
                                        </Container>
                                    </Col>}
                                    {props.data.hotelRoom.balcony && <Col className="col-auto">
                                        <Container
                                            className="py-1 px-1">
                                            <Row className="d-flex flex-row">
                                                <Col className="m-0 w-25 py-1">
                                                    <MdBalcony className="my-0 " color="#159895" size={40}></MdBalcony>
                                                </Col>
                                                <Col className="w-75 d-flex p-0">
                                                    <h6 style={{fontSize: "14px"}} className="m-auto">Тераса</h6>
                                                </Col>
                                            </Row>
                                        </Container>
                                    </Col>}
                                </Row>
                            </Col>
                        </Row>
                    </Container>
                    <Container className={'border mt-3 w-75 py-3 rounded-3'}>
                        <Row className={'mb-3'}>
                            <Col>
                                <h5>4 Ноќевања</h5>
                            </Col>
                            <Col>
                                <h5 className={'text-end'}>32$</h5>
                            </Col>
                        </Row>
                        <Row>
                            <Col>
                                <h5>Вкупно</h5>
                            </Col>
                            <Col>
                                <h4 className={'text-end'}>128$</h4>
                            </Col>
                        </Row>
                    </Container>
                </Modal.Body>
                <Modal.Footer>
                    <Button variant="secondary" onClick={props.handleClose}>
                        Затвори
                    </Button>
                    <Button variant="danger" onClick={() => {
                        createEntity(`/hotel/${props.data.reservationId}/cancel`, props.setChanged)
                        props.handleClose()
                    }
                    }>
                        Откажи резервација
                    </Button>
                </Modal.Footer>
            </Modal>

        </>
    )
}

export default HotelReservationModal;