package com.tourMate.config;

import com.tourMate.entities.Hotels;
import com.tourMate.entities.User;
import com.tourMate.services.HotelManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.stereotype.Component;

import java.util.function.Supplier;

@Component
public class UserSecurity implements AuthorizationManager<RequestAuthorizationContext> {

    @Override
    public AuthorizationDecision check(Supplier authenticationSupplier, RequestAuthorizationContext ctx) {
        Long userId = Long.parseLong(ctx.getVariables().get("userId"));
        Authentication authentication = (Authentication) authenticationSupplier.get();
        return new AuthorizationDecision(hasUserId(authentication, userId));
    }

    public boolean hasUserId(Authentication authentication, Long userId) {
        System.out.println(userId);
        User user = (User) authentication.getPrincipal();
        System.out.println(user.getUserID());
        System.out.println(authentication.getPrincipal());
        return userId == user.getUserID();
    }

}
