package com.tourMate.dao;

import com.tourMate.entities.*;
import jakarta.transaction.Transactional;

import java.util.Date;
import java.util.List;

public interface RestaurantDao {
    @Transactional
    void createRestaurant(Restaurant restaurant);
    List<RestaurantsAvailible> getTablesByDateAndLocation(String restaurantLocation, Date hourFrom, Date hourTo, int noSeats);
    @Transactional
    void addRestaurantImage(RestaurantImages restaurantImages);
    @Transactional
    void removeRestaurantImage(RestaurantImages image);
    @Transactional
    void saveTable(RestaurantsTable resTable);
    @Transactional
    RestaurantImages findRestaurantImageById(long restaurantImageId);
    void deleteRestaurant(Restaurant r);
    List<Restaurant> getRestaurants();
    @Transactional
    void addMenuToRestaurant(Menu menu);
    Restaurant findRestaurantByID(long restaurantID);
    List<RestaurantImages> getRestaurantImages(long restaurantID);
    List<RestaurantsTable> getRestaurantTables(long restaurantID);
    RestaurantsTable findTableById(long tableId);
    @Transactional
    void deleteTable(RestaurantsTable rt);
    List<Restaurant> getRestaurantsByUser(User u);
    List<RestaurantsAvailible> getTablesAvailabilityById(Long id);
    @Transactional
    void saveTableAvailable(RestaurantsAvailible ra);
    @Transactional
    void deleteTableAvailable(RestaurantsAvailible ra);

    List<RestaurantsAvailible> getTablesAvailability();

    //    List<RestaurantsAvailible> getTablesAvailability();
    @Transactional
    void createReservation(RestaurantReservations reservations);
    @Transactional
    void deleteReservation(RestaurantReservations r);
    RestaurantReservations findReservationByID(long tableId);
    RestaurantsAvailible findAvailableReservationByID(long availibleId);
    List<RestaurantReservations> findReservationByUser(User user);
    List<RestaurantReservations> findReservationByRestaurant(Restaurant restaurant);
    List<RestaurantReservations> getReservations();
    List<Restaurant> searchByRestaurantName(String restaurantName);

    List<Restaurant> searchByRestaurantLocation(String restaurantLocation);

    List<RestaurantsTable> searchByNoSeats(int noSeats);

    List<Reviews> findReviewsByRestaurant(Restaurant restaurant);

    List<RestaurantReservations> findPastReservationsByUser(User user);

    List<MenuImages> getMenuImages(long menuId);

    List<MenuImages> getMenuImagesByRestaurant(Restaurant restaurant);

    @Transactional
    void addMenuImage(MenuImages menuImages);

    Menu findMenuId(Long menuId);

    void saveReservation(RestaurantReservations r);

//    public void createRestaurant(Restaurant restaurant, long userId);
//    public void deleteRestaurant(long restaurantID);
//    @Transactional
//    public void editRestaurant(long restaurantID, String restaurantName, String restaurantLocation, String cousineType, String restaurantDescription, String restaurantEdbs, User restaurantOwner);
//    public Restaurant findRestaurantByID (long restaurantID);
//    public List<Restaurant> searchByRestaurantName(String restaurantName);
//    public List<Restaurant> searchByRestaurantLocation(String restaurantLocation);
//    public List<Restaurant> getRestaurants();
//    @Transactional
//    public void addMenuToRestaurant(long restaurantId, Menu menu);
//
//    public List<RestaurantsAvailible> getTablesByDateAndLocation(String restaurantLocation, Date hourFrom, Date hourTo, int noSeats);
//
//    public void createTable(Restaurant restaurant, int noSeats);
//    public void editTable(Restaurant restaurant, long tableId, int noSeats);
//    public void deleteTable(long tableId);
//    public List<Restaurant> getRestaurantsByUser(long userId);
//    public RestaurantsTable findTableById(long tableId);
//    public List<RestaurantsTable> searchByNoSeats(int noSeats);
//    public List<RestaurantsTable> getRestaurantTables(long restaurantID);
//
//    public void addRestaurantImage(RestaurantImages restaurantImages);
//    public void removeRestaurantImage(long restaurantImageId);
//    public RestaurantImages findRestaurantImageById(long restaurantImageId);
//    public List<RestaurantImages> getRestaurantImages(long restaurantID);
//
//    public void createTableAvailable(RestaurantsTable restaurantsTable, Date hourFrom, Date hourTo, int noSeats);
//    @Transactional
//    abstract void createTableAvailable(RestaurantsTable restaurantsTable, Date hourFrom, Date hourTo);
//    public List<RestaurantsAvailible> getTablesAvailabilityById(Long id);
//    public void editTableAvailable(long tableId, Restaurant restaurant, int noSeats);
//    public void deleteTableAvailable(long tableId);
//    public RestaurantsAvailible findAvailableReservationByID(long availibleId);
//
//    public List<RestaurantsAvailible> getTablesAvailability();
//    public void createReservation(RestaurantReservations reservations);
//    public void editReservation(long restaurantsTableId, RestaurantsTable rt, Date hourFrom, Date hourTo, int noSeats, User user);
//    public void deleteReservation(long restaurantsTableId);
//    public RestaurantReservations findReservationByID(long tableId);
//    public List<RestaurantReservations> findReservationByUser(User user);
//    public List<RestaurantReservations> findReservationByRestaurant(Restaurant restaurant);
//    public List<RestaurantReservations> getReservations();
//
//    List<Reviews> findReviewsByRestaurant(Restaurant restaurant);
//
//    List<RestaurantReservations> findPastReservationsByUser(User u);
//    List<MenuImages> getMenuImages(long menuId);
//    public void addMenuImage(MenuImages menuImages);
//
//    Menu findMenuId(Long menuId);
//
//    void saveReservation(RestaurantReservations restaurantReservations);
}
