import React from "react";
import Form from "react-bootstrap/Form";
import FaHotel from "react-icons/fa";
import {Button} from "react-bootstrap";
import useCreate from "../Hooks/useCreate";
import RoomRow from "./RoomRow";

const RoomsTable = (props) => {

    return (
        <>
            <table className="m-auto table table-hover table-responsive">
                <thead>
                <tr>
                    <th scope="col">Тип на соба</th>
                    <th scope="col">Цена</th>
                    <th scope="col">Колку единици?</th>
                    <th scope="col"></th>
                </tr>
                </thead>
                <tbody>
                {Array.from(
                    new Set(props.data.map((x) => JSON.stringify(x.hotelRoom)))
                ).map((roomString) => JSON.parse(roomString)).map((room) => {
                    return (
                        <>
                            <RoomRow
                                availableId={props.data.filter(x => x.hotelRoom.hotelRoomId === room.hotelRoomId).
                                map(x => x.hotelRoomAvailableId)[0]}
                                data={props.data} room={room} from={props.from} to={props.to}/>
                        </>
                    );
                })}
                </tbody>
            </table>
        </>
    );
};

export default RoomsTable;
