import {Col, Container, Row} from "react-bootstrap";
import React from "react";

const ReservationListing = (props) => {

    const dateFormatter = (str) => {
        const inputDate = new Date(str);

        const options = {
            year: '2-digit',
            month: '2-digit',
            day: '2-digit',
        };

        return inputDate.toLocaleString('de-DE', options);
    }

    return(
        <>
            <Container className="py-3 px-1 my-4"
                       style={{
                           border: "4px solid #159895",
                           borderRadius: "1em",
                           boxShadow: "0 3px 5px #159895",
                           maxWidth: "90%",
                       }}>
                <Row>
                    <Col md={8} className="d-flex flex-column justify-content-start ps-5">
                        <h3 style={{fontWeight: "bold"}} className={'text-start'}>Резервација за:</h3>
                        {props.type === 'hotel' && <h4 className={'text-start'}>{props.data.hotelRoom.hotelRoomName}</h4>}
                        {props.type === 'restaurant' && <h4 className={'text-start'}>{'Маса за ' + props.data.restaurantsTable.noSeats}</h4>}
                        {props.type === 'transport' && <h4 className={'text-start'}>{props.data.transportRoute.from + ' ' + props.data.transportRoute.to}</h4>}
                        {props.type === 'transport' && <h4 className={'text-start'}>{props.data.noSeats + ' ' + 'патници'}</h4>}
                        <h4 className={'text-start'}>{props.data.user.name + ' ' + props.data.user.surname}</h4>
                        {props.type !== 'transport' && <h5
                            className={'text-start'}>{dateFormatter(props.data.dateFrom) + ' - ' + dateFormatter(props.data.dateTo)}</h5>}
                    </Col>
                    <Col md={4} className="d-flex flex-column justify-content-center align-content-center">
                        {props.type === 'hotel' && <h3>Вкупна цена: <br></br>{props.data.hotelRoom.price}$</h3>}
                    </Col>
                </Row>
            </Container>
        </>
    )
}

export default ReservationListing;