import React, {useState} from "react";
import Navigation from '../Components/Layout/Navbar/Navigation';
import 'bootstrap/dist/css/bootstrap.css';
import 'bootstrap/dist/js/bootstrap.js';
import HomeCarousel from '../Components/Layout/CarouselHome/Carousel';
import {Card, Container, Nav, Row, Col} from 'react-bootstrap';
import TabComponent from '../Components/Tab/Tab';
import Offers from '../Components/Layout/Offers/Offers';
import MostVisitedBar from '../Components/MostVisited/MostVisitedBar';
import MostPopularRoutesCont from '../Components/MostPopularRoutes/MostPopularRoutesCont';
import BecomeAHost from "../Components/BecomeAHost/BecomeAHost"
import HotelLisitng from "../Components/Listings/HotelListing"
import SearchCriteriasHotel from "../Components/SearchCriterias/SearchCriteriasHotel";
import SortButton from "../Components/Listings/SortButton";
import FilterButton from "../Components/Listings/FilterButton";
import TransportListing from "../Components/Listings/TransportListing";
import useGet from "../Components/Hooks/useGet";
import {useParams} from "react-router-dom";
import SearchCriteriasBar from "../Components/SearchCriterias/SearchCriteriasBar";
import RestaurantDetailsPage from "./RestaurantDetailsPage";
import RestaurantListing from "../Components/Listings/RestaurantListing";


const SearchPage = (props) => {

    const params = useParams();
    console.log(params)
    const [sortingArg, setSortingArg] = useState("")

    document.body.style.backgroundColor = "white"
    var hotelData = {
        "hotelName": "Име на сместувањето",
        "hotelLocation": "Скопје, Македонија",
        "hotelCaption": "Краток опис",
        "hotelDescription": "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation",
        "hotelPrice": 504.99,
        "hotelRating": 9.1

    }

    const getSortingFn = (type, arg) => {
        if (type === 'hotel') {
            if (arg === "priceAsc")
            {
                return (a, b) => {
                    return a.totalPrice - b.totalPrice;
                }
            }
            else if (arg === "priceDesc")
            {
                return (a, b) => {
                    return -(a.totalPrice - b.totalPrice);
                }
            }
            else if (arg === 'nameAsc')
            {
                return (a, b) => {
                    return a.hotelName.localeCompare(b.hotelName);
                }
            }
            else if(arg === 'nameDesc')
            {
                return (a, b) => {
                    return -a.hotelName.localeCompare(b.hotelName);
                }
            }
        }
        else if (type === 'transport')
        {
            if (arg === "priceAsc")
            {
                return (a, b) => {
                    return a.price - b.price;
                }
            }
            else if (arg === "priceDesc")
            {
                return (a, b) => {
                    return -(a.price - b.price);
                }
            }
        }
        else if (type === 'restaurant')
        {
            if (arg === 'nameAsc')
            {
                return (a, b) => {
                    return a.restaurantName.localeCompare(b.restaurantName);
                }
            }
            else if(arg === 'nameDesc')
            {
                return (a, b) => {
                    return -a.restaurantName.localeCompare(b.restaurantName);
                }
            }
        }
    }

    let link = props.type === "transport" ? `/transport/search?from=${params.from}&to=${params.to}&date=${params.date}&numPassengers=${params.numPassengers}` : props.type === "hotel" ? `/hotel/search?hotelLocation=${params.hotelLocation}&dateFrom=${params.dateFrom}&dateTo=${params.dateTo}&numBeds=${params.numBeds}&flexible=${params.flexible}` : `/restaurant/search?restaurantLocation=${params.restaurantLocation}&date=${params.date}&hourFrom=${params.hourFrom}&hourTo=${params.hourTo}&numPeople=${params.numPeople}`
    console.log(link)
    console.log(params.date)
    const {data, isLoading, getData, setData} = useGet(link);
    !isLoading && console.log(data)
    return (
        <>
            <Navigation></Navigation>
            <SearchCriteriasBar type={props.type} criterias={useParams()}></SearchCriteriasBar>
            <Container className="d-flex justify-content-end gx-5" style={{maxWidth: "60%"}}>
                <Row>
                    <Col>
                        <FilterButton></FilterButton>
                    </Col>
                    <Col>
                        <SortButton setSortingArg={setSortingArg} type={props.type}></SortButton>
                    </Col>
                </Row>
            </Container>
            {props.type === "hotel" && !isLoading && data && <Container fluid>
                {data.sort(getSortingFn(props.type, sortingArg)).map(hotel => {
                    return <HotelLisitng from={params.dateFrom} to={params.dateTo} data={hotel}/>
                })}
            </Container>}
            {props.type === "transport" && !isLoading && data && <Container fluid>
                {data.sort(getSortingFn(props.type, sortingArg)).map(transport => {
                    return <TransportListing params={params} data={transport}/>
                })}
            </Container>}
            {props.type === "restaurant" && !isLoading && data && <Container fluid>
                {data.sort(getSortingFn(props.type, sortingArg)).map(restaurant => {
                    return <RestaurantListing params={params} data={restaurant}/>
                })}
            </Container>}
        </>
    )
}

export default SearchPage;