package com.tourMate.dao;


import com.tourMate.entities.*;
import jakarta.transaction.Transactional;

import java.util.Date;
import java.util.List;

public interface HotelDao {
    @Transactional
    void createHotel(Hotels hotel);

    List<Hotels> getHotels();

    List<Hotels> getHotelsForUser(User u);

    List<Hotels> getHotelsByLocation(String hotelLocation);

    @Transactional
    void editHotel(Hotels hotel);

    @Transactional
    void deleteHotel(Hotels hotel);

    Hotels findHotelByID(long hotelId);

    List<HotelsImages> getHotelImages(Hotels hotel);

    @Transactional
    void addHotelImage(HotelsImages image);

    @Transactional
    void addRoomImage(HotelRoomImages x);

    @Transactional
    void  saveReservation(HotelRoomReservations hotelRoomReservations);

    @Transactional
    HotelsImages findHotelImageById(long hotelImageId);

    @Transactional
    void deleteHotelImage(HotelsImages hotelsImages);

    List<HotelRoom> getRoomsOfHotel(Hotels hotel);

    List<HotelRoomAvailable> getRoomsAvailable(Long id);

    HotelRoom findRoomById(long hotelRoomId);

    List<HotelRoomImages> getRoomImages(HotelRoom hotelRoom);

    @Transactional
    void createRoom(HotelRoom hotelRoom);

    @Transactional
    void editRoom(HotelRoom hr);

    @Transactional
    void deleteRoom(HotelRoom hr);

    @Transactional
    void createRoomAvailible(HotelRoomAvailable hra);

    @Transactional
    void editRoomAvailible(HotelRoomAvailable hr);

    @Transactional
    void deleteRoomAvailible(HotelRoomAvailable hra);

    HotelRoomAvailable findAvailibleRoomById(long hotelRoomAvailableId);

    List<HotelRoomAvailable> getRoomsAvailibility();

    List<HotelRoomAvailable> getRoomsAvailibilityByHotel(Hotels hotel);

    List<HotelRoomAvailable> getRoomsAvailibilityByDateAndLocation(String hotelLocation, Date dateFrom, Date dateTo, int numberOfBeds, Boolean flexible);

    @Transactional
    void createReservation(HotelRoomReservations r);

    @Transactional
    void editReservation(HotelRoomReservations hr);

    @Transactional
    void deleteReservation(HotelRoomReservations hr);

    HotelRoomReservations findReservationById(long hotelRoomReservedId);

    List<HotelRoomReservations> findReservationByUser(User user);

    List<HotelRoomReservations> findReservationByHotel(Hotels hotel);

    List<HotelRoomReservations> getReservations();

    List<Reviews> findReviewsByHotel(Hotels hotel);

    List<HotelRoomReservations> findPastReservationByUser(User u);
//    public void createHotel(Hotels hotel, long userId);
//    public void editHotel(long hotelId, String hotelName, String hotelDescripiton, String hotelLocation, String hotelEDBS, Boolean parking, Boolean petFriendly, Boolean internetAvailable);
//    public void deleteHotel(long hotelId);
//    public Hotels findHotelByID (long hotelId);
//    public List<Hotels> getHotels();
//    public List<Hotels> getHotelsForUser(long userId);
//    public List<Hotels> getHotelsByLocation(String hotelLocation);
//
//    public void deleteHotelImage(long hotelImageId);
//    public HotelsImages findHotelImageById(long hotelImageId);
//    public List<HotelsImages> getHotelImages(Hotels hotels);
//    public List<HotelRoomImages> getRoomImages(HotelRoom hotelRoom);
//
//    public void createRoom(Hotels hotel, String hotelRoomDescription, String hotelRoomName, Boolean kitchenAvailable, Boolean airConditioning, Boolean balcony, double price, int numOfBeds);
//    public void editRoom(long hotelRoomId, Hotels hotel, String hotelRoomDescription, String HotelRoomName, Boolean kitchenAvailable, Boolean airConditioning, Boolean balcony, double price);
//    public void deleteRoom(long hotelRoomId);
//    public HotelRoom findRoomById (long hotelRoomId);
//    public List<HotelRoom> getRoomsOfHotel (long hotelId);
//    public List<HotelRoomAvailable> getRoomsAvailable(Long id);
//
//    @Transactional
//    public void createRoomAvailible(HotelRoom hotelRoom, Date dateFrom, Date dateTo, int numberOfBeds);
//    public void editRoomAvailible(long hotelRoomAvailableId, HotelRoom hotelRoom, Date dateFrom, Date dateTo, int numberOfBeds);
//    public void deleteRoomAvailible(long hotelRoomAvailableId);
//    public HotelRoomAvailable findAvailibleRoomById(long hotelRoomAvailableId);
//    public List<HotelRoomAvailable> getRoomsAvailibility();
//    public List<HotelRoomAvailable> getRoomsAvailibilityByHotel(Hotels hotel);
//    public List<HotelRoomAvailable> getRoomsAvailibilityByDateAndLocation(String hotelLocation, Date dateFrom, Date dateTo, int numberOfBeds, Boolean flexible);
//
//    public void createReservation(User user, HotelRoom hotelRoom, Date dateFrom, Date dateTo, Integer numberOfBeds);
//    public void editReservation(long hotelRoomReservedId, User user, HotelRoom hotelRoom, Date dateFrom, Date dateTo, Integer numberOfBeds);
//    public void deleteReservation(long hotelRoomReservedId);
//    public HotelRoomReservations findReservationById(long hotelRoomReservedId);
//    public List<HotelRoomReservations> findReservationByUser(User user);
//    public List<HotelRoomReservations> findReservationByHotel(Hotels hotel);
//    public List<HotelRoomReservations> getReservations();
//
//    List<Reviews> findReviewsByHotel(Hotels hotel);
//
//    List<HotelRoomReservations> findPastReservationByUser(User u);
//
//    void addHotelImage(HotelsImages x);
//
//    void addRoomImage(HotelRoomImages x);
//    void saveReservation(HotelRoomReservations hotelRoomReservations);
}
