import useGet from "../Hooks/useGet";
import {Container} from "react-bootstrap";
import { FaLock, FaLockOpen } from "react-icons/fa";
import React from "react";
import useApprove from "../Hooks/useApprove";

const AllProfilesTable = () => {

    const { data, isLoading, setData, getData, setChanged } = useGet('/user')
    const { getData: approveProfile} = useApprove()

    !isLoading && console.log(data)

    const dateFormatter = (str) => {
        const inputDate = new Date(str);

        const options = {
            year: '2-digit',
            month: '2-digit',
            day: '2-digit',
            hour12: false,
        };

        return inputDate.toLocaleString('mk-MK', options);

    }

    return (
        <>
            <Container fluid >
                <table className="table table-hover">
                    <thead>
                    <tr>
                        <th scope="col"></th>
                        <th scope="col">Име и презиме</th>
                        <th scope="col">Адреса</th>
                        <th scope="col">Email</th>
                        <th scope="col">Датум на раѓање</th>
                        <th scope="col">Контакт телефон</th>
                        <th>Акции</th>
                    </tr>
                    </thead>
                    <tbody>
                    {!isLoading && data.map((f, i) => { return <tr key={f.userID}>
                        <th style={{verticalAlign: "middle"}} scope="row">{i + 1}</th>
                        <td style={{verticalAlign: "middle"}}>{f.name + ' ' + f.surname}</td>
                        <td style={{verticalAlign: "middle"}}>{f.address}</td>
                        <td style={{verticalAlign: "middle"}}>{f.email}</td>
                        <td style={{verticalAlign: "middle"}}>{dateFormatter(f.birthDate)}</td>
                        <td style={{verticalAlign: "middle"}}>{f.contact}</td>
                        <td style={{verticalAlign: "middle"}}>
                            {f.accountNonLocked &&
                                <FaLock size={'2.2em'} color={'#159895'} onClick={() => {
                                    approveProfile('/users/unlock/' + f.userID).then(() => {
                                        setChanged((prev) => {
                                            return Math.random();
                                        })
                                    })
                                }}/>}
                            {!f.accountNonLocked &&
                                <FaLockOpen size={'2.2em'} color={'#159895'} onClick={() => {
                                    approveProfile('/users/unlock/' + f.userID).then(() => {
                                        setChanged((prev) => {
                                            return Math.random();
                                        })
                                    })
                                }}/>}
                        </td>
                    </tr>})}
                    </tbody>
                </table>
            </Container>
        </>
    )
}

export default AllProfilesTable;