import {Button, Form, Modal, Row} from "react-bootstrap";
import React from "react";
import useFormData from "../Hooks/useFormData";
import useCreate from "../Hooks/useCreate";

const ReviewModal = (props) => {
    const dummy = {
        tite: "",
        numStars: "",
        description: "",
    }
    console.log(props)

    const {createEntity} = useCreate();

    const {formData, setFormData, onFormChange} = useFormData(dummy)

    return (
        <>
            <Modal show={props.showReview} onHide={props.handleCloseReview}>
                <Modal.Header closeButton>
                    <Modal.Title>Внесување оценка по резервација</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <Form>
                        <Row>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    type="text"
                                    placeholder="Каде ќе патувате?:"
                                    id="title"
                                    name="title"
                                    onChange={onFormChange}
                                    value={formData.title}
                                ></Form.Control>
                                <label style={{left: '10px'}} htmlFor="location">Наслов:</label>
                            </Form.Floating>
                        </Row>
                        <Row>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    type="number"
                                    max={5}
                                    min={1}
                                    placeholder="Каде ќе патувате?:"
                                    id="numStars"
                                    name="numStars"
                                    onChange={onFormChange}
                                    value={formData.numStars}
                                ></Form.Control>
                                <label style={{left: '10px'}} htmlFor="location">Број на ѕвезди:</label>
                            </Form.Floating>
                        </Row>

                        <Row>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    as="textarea"
                                    placeholder="Каде ќе патувате?:"
                                    id="description"
                                    name="description"
                                    onChange={onFormChange}
                                    value={formData.description}
                                ></Form.Control>
                                <label style={{left: '10px'}} htmlFor="location">Опис:</label>
                            </Form.Floating>
                        </Row>

                    </Form>
                </Modal.Body>
                <Modal.Footer>
                    <Button variant="secondary" onClick={props.handleClose}>
                        Затвори
                    </Button>
                    <Button variant="primary" onClick={() => {
                        // console.log(props.data.hotelId)
                        const dataToPost = props.type === 'hotel' ? {
                                ...formData,
                                hotelId: props.data.hotelId,
                                userId: 1,
                                reservationId: props.data.reservationId
                            } :
                            props.type === 'restaurant' ? {
                                ...formData,
                                restaurantId: props.data.restaurantId,
                                userId: 1,
                                reservationId: props.data.reservationId
                            } : {
                                ...formData,
                                transportId: props.data.transportId,
                                userId: 1,
                                reservationId: props.data.reservationId
                            }
                        createEntity('/review/add', dataToPost, props.setChanged)
                        setFormData(dummy)
                        props.handleCloseReview()
                    }
                    }>
                        Зачувај
                    </Button>
                </Modal.Footer>
            </Modal>
        </>
    )
}

export default ReviewModal;