package com.tourMate.dao;

import com.tourMate.entities.Business;
import com.tourMate.entities.User;
import jakarta.transaction.Transactional;

import java.util.List;

public interface BusinessDao {

    List<Business> getCreatedBusinesses();

    Business findBusinessById(long businessId);

    @Transactional
    void createBusiness(Business business);

    List<Business> getUnapprovedBusinessesOfUser(User u);

    @Transactional
    void deleteBusiness(Business business);

    boolean hasBusiness(User u);

    List<Business> getUnapprovedBusinesses();

    void approveBusiness(Business business);

    @Transactional
    void editBusiness(Business business);
}
