package com.tourMate.dao.impl;

import com.tourMate.dao.BusinessDao;
import com.tourMate.entities.Business;
import com.tourMate.entities.User;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BusinessDaoImpl implements BusinessDao {

    @PersistenceContext
    EntityManager em;

    @Transactional
    @Override
    public void createBusiness(Business business) {
        em.persist(business);
    }

    @Override
    public List<Business> getUnapprovedBusinessesOfUser(User u) {
        return em.createQuery("SELECT b FROM Business b WHERE b.user = :user").setParameter("user", u).getResultList();
    }

    @Transactional
    @Override
    public void deleteBusiness(Business business) {
        em.remove(business);
    }

    @Override
    public boolean hasBusiness(User u)
    {
        return Integer.parseInt(em.createQuery("SELECT COUNT(b) FROM Business b WHERE b.user = :user").setParameter("user", u).getSingleResult().toString()) > 0;
    }

    @Override
    public List<Business> getUnapprovedBusinesses() {
        return em.createQuery("select b from Business b where not b.approved").getResultList();
    }

    @Override
    @Transactional
    public void approveBusiness(Business b) {
        em.persist(b);
    }


    @Override
    public List<Business> getCreatedBusinesses() {
        return em.createQuery("from Business order by businessId").getResultList();
    }

    @Override
    public Business findBusinessById(long businessId) {
        return em.find(Business.class, businessId);
    }


    @Transactional
    @Override
    public void editBusiness(Business business) {
        em.persist(business);
    }
}
