package com.tourMate.dto;
import com.tourMate.entities.HotelRoom;
import com.tourMate.entities.User;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

public class HotelReservationUserDto {
    private Long reservationId;
    private User user;
    private HotelRoom hotelRoom;
    private Long hotelId;
    @DateTimeFormat(pattern = "dd.MM.yyyy")
    private Date dateFrom;
    @DateTimeFormat(pattern = "dd.MM.yyyy")
    private Date dateTo;
    private Integer numBeds;
    private String hotelName;
    private String hotelLocation;
    private String hotelAddress;
    private Boolean reviewed;

    public HotelReservationUserDto(Long reservationId, User user, HotelRoom hotelRoom, Date dateFrom, Date dateTo, Integer numBeds, String hotelName, String hotelLocation, String hotelAddress, Long hotelId, Boolean reviewed) {
        this.reservationId = reservationId;
        this.user = user;
        this.hotelRoom = hotelRoom;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.numBeds = numBeds;
        this.hotelLocation = hotelLocation;
        this.hotelName = hotelName;
        this.hotelAddress = hotelAddress;
        this.hotelId = hotelId;
        this.reviewed = reviewed;
    }

    public Long getReservationId() {
        return reservationId;
    }

    public User getUser() {
        return user;
    }

    public HotelRoom getHotelRoom() {
        return hotelRoom;
    }

    public Date getDateFrom() {
        return dateFrom;
    }

    public Date getDateTo() {
        return dateTo;
    }

    public Integer getNumBeds() {
        return numBeds;
    }

    public String getHotelName() {
        return hotelName;
    }

    public String getHotelLocation() {
        return hotelLocation;
    }
    public String getHotelAddress() {
        return hotelAddress;
    }

    public Long getHotelId() {
        return hotelId;
    }

    public Boolean getReviewed() {
        return reviewed;
    }
}
