package com.tourMate.services;
import com.tourMate.entities.Business;
import com.tourMate.entities.User;

import java.util.List;

public interface BusinessManager {
    public void createBusiness(Business business, long userId);
    public List<Business> getUnapprovedBusinessesOfUser(long userId);

    void deleteBusiness(long businessId);

    public List<Business> getUnapprovedBusinesses();
    public void approveBusiness(Long businessId);
    public Business findBusinessById (long businessId);
    public boolean hasBusiness(long userId);

    void editBusiness(long businessId, String name, String phone, String address, String edbs, User user, boolean approved);
}
