package com.tourMate.services.impl;

import com.tourMate.dao.BusinessDao;
import com.tourMate.dao.UsersDao;
import com.tourMate.entities.Business;
import com.tourMate.entities.Role;
import com.tourMate.entities.User;
import com.tourMate.services.BusinessManager;
import com.tourMate.services.UsersManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import java.util.List;

@Service
public class BusinessManagerImpl implements BusinessManager {

    @Autowired
    BusinessDao businessDao;
    @Autowired
    UsersDao usersDao;
    @Autowired
    UsersManager usersManager;

    @Override
    public void createBusiness(Business business, long userId) {
        User u = usersManager.findUserByID(userId);
        business.setUser(u);
        businessDao.createBusiness(business);
    }

    @Override
    public List<Business> getUnapprovedBusinessesOfUser(long userId) {
        User u = usersManager.findUserByID(userId);
        return businessDao.getUnapprovedBusinessesOfUser(u);
    }

    @Override
    public void deleteBusiness(long businessId) {
        Business business = businessDao.findBusinessById(businessId);
        businessDao.deleteBusiness(business);

    }

    @Override
    public List<Business> getUnapprovedBusinesses() {
        return businessDao.getUnapprovedBusinesses();
    }

    @Override
    public void approveBusiness(Long businessId) {
        Business b = findBusinessById(businessId);
        b.setApproved(true);
        businessDao.approveBusiness(b);
        changeUserRoleBusiness(b.getUser().getUserID());
    }

    private void changeUserRoleBusiness(Long userId)
    {
        User u = usersDao.findUserByID(userId);
        Role r = usersDao.findById(3L);
        u.setRole(r);
        usersDao.updateUser(u);
    }

    @Override
    public boolean hasBusiness(long userId){
        User u = usersManager.findUserByID(userId);
        return businessDao.hasBusiness(u);
    }

    @Override
    public Business findBusinessById(long businessId) {
        return businessDao.findBusinessById(businessId);
    }

    @Override
    public void editBusiness(long businessId, String name, String phone, String address, String edbs, User user, boolean approved) {
        Business business = findBusinessById(businessId);
        business.setName(name);
        business.setPhone(phone);
        business.setAddress(address);
        business.setEdbs(edbs);
        business.setUser(user);
        business.setApproved(approved);
        businessDao.editBusiness(business);
    }

}
