import { useState } from "react";
import axios from "../../../axios.js";
import {useAuth} from "../../Context/AuthContext"; // Assuming you have axios configured

const useLogin = () => {
	const [loading, setLoading] = useState(false);
	const [error, setError] = useState(null);
	const Auth = useAuth();

	const handleLoginCallback = async () => {
		setLoading(true);

		try {
			const response = await axios.get("http://localhost:8080/principal");

			// Extract the needed attributes from the response
			const { id, role, username } = response.data;

			Auth.userLogin({userId: id, username: username, role: role})

		} catch (err) {
			setError(err.message);
		} finally {
			setLoading(false);
		}
	};

	return {
		loading,
		error,
		handleLoginCallback,
	};
};

export default useLogin;
