import React from "react";
import {Col, Row, Image, Container} from "react-bootstrap";
import Carousel from "react-bootstrap/Carousel";

const MenuItem = (props) => {

    const data = props.data;
    console.log(props)
    return (<>

        <a href="#" style={{textDecoration: "none", color: "black"}}>
            <Container className="py-3 px-1 my-4"
                       style={{
                           border: "4px solid #159895",
                           borderRadius: "1em",
                           boxShadow: "0 3px 5px #159895",
                           maxWidth: "90%"
                       }}>
                <Row>
                    <Col className="d-flex justify-content-center mb-3">
                        <Carousel>
                            {props.images.map((image) => {
                                let link = image.url;
                                if (image.url.includes('Desktop')) {
                                    link = 'http://localhost:8080/download?fileName=' + encodeURIComponent(image.url);
                                }
                                return (
                                    <Carousel.Item>
                                        <img
                                            className="d-block w-100 h-400 rounded-5"
                                            src={link}
                                            alt="First slide"
                                            style={{
                                                height: "7em",
                                                borderRadius: "1em",
                                                boxShadow: "0 4px 20px lightblue",
                                                maxWidth: "100%",
                                            }}
                                        />
                                    </Carousel.Item>
                                )
                            })}
                            {props.images.length == 0 && <Carousel.Item>
                                <Image
                                    src="https://www.tasteofhome.com/wp-content/uploads/2019/01/medium-rare-steak-shutterstock_706040446.jpg"
                                    style={{
                                        height: "7em",
                                        borderRadius: "1em",
                                        boxShadow: "0 4px 20px lightblue",
                                        maxWidth: "100%",
                                    }}
                                ></Image>
                            </Carousel.Item>}
                        </Carousel>
                    </Col>
                </Row>
                <Row>
                    <Col className="d-flex flex-column justify-content-center " style={{textAlign: "center"}}>
                        <h4>{data.name}</h4>
                        <h6>{data.ingredients}</h6>
                    </Col>
                </Row>
                <Row>
                    <Col className="d-flex flex-column justify-content-center align-content-center">

                        <h5>Цена: {data.price}$</h5>
                    </Col>
                </Row>
            </Container>
        </a>

    </>)
}

export default MenuItem;