import React from "react";
import Navigation from "../Components/Layout/Navbar/Navigation";
import {Container, Row} from "react-bootstrap";
import ConnectedAccountsTable from "../Components/ConnectedAccounts/ConnectedAccountsTable";
import LoginForm from "../Components/Login/LoginForm";
import {useAuth} from "../Components/Context/AuthContext";
import useGet from "../Components/Hooks/useGet";

const ConnectedAccountsPage = () => {
    const Auth = useAuth();
    console.log(Auth.getUser())
    const { data, isLoading, setData, getData, setChanged } = useGet(`/users/${Auth.getUser().userId}/connected`);


    return (
        <>
            <Navigation/>
            <Container>
                <Row className="mb-5">
                    <h2 style={{color: "#159895", textAlign: "left"}}>Поврзани профили</h2>
                </Row>
            </Container>
            <Container>
                {!isLoading && <ConnectedAccountsTable data={data}></ConnectedAccountsTable>}
            </Container>
            <Container className={'mt-5'}>
                <Row className="mb-5">
                    <h2 style={{color: "#159895", textAlign: "left"}}>Поврзи нов локален профил</h2>
                </Row>
            </Container>
            <Container className={'w-50'}>
                <LoginForm refresh={setChanged}></LoginForm>
            </Container>
        </>
    )
}

export default ConnectedAccountsPage;