package com.tourMate.config;

import com.tourMate.config.oauth2.CustomOAuth2FailureHandler;
import com.tourMate.config.oauth2.CustomOAuth2SuccessHandler;
import com.tourMate.config.oauth2.CustomOAuth2UserDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.HttpStatusReturningLogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import java.util.Arrays;

@Configuration
@EnableWebSecurity
public class SecurityConfig {

    private final UserSecurity userSecurity;
    @Autowired
    private CustomOAuth2UserDetailService customOAuth2UserDetailService;
    @Autowired
    private CustomOAuth2FailureHandler oAuth2FailureHandler;
    @Autowired
    private CustomOAuth2SuccessHandler oAuth2SuccessHandler;

    public SecurityConfig(UserSecurity userSecurity) {
        this.userSecurity = userSecurity;
    }

    @Bean
    public CorsConfiguration corsConfiguration() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(true);
        config.addAllowedOrigin("http://localhost:3000");
        config.addAllowedHeader("*");
        config.setAllowedMethods(Arrays.asList(
                HttpMethod.POST.name(),
                HttpMethod.GET.name(),
                HttpMethod.DELETE.name(),
                HttpMethod.PUT.name()
        ));
        config.setMaxAge(3600L);
        return config;
    }


    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", corsConfiguration());
        FilterRegistrationBean<CorsFilter> bean = new FilterRegistrationBean<>(new CorsFilter(source));
        bean.setOrder(-102);
        return bean;
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http
                .csrf().disable()
                .authorizeHttpRequests((authz) -> {
                            try {
                                authz
                                        .requestMatchers(new AntPathRequestMatcher("/{userId}/hasBusiness")).access(userSecurity)
                                        .requestMatchers(new AntPathRequestMatcher("/business/*/unapproved")).permitAll()
                                        .requestMatchers(new AntPathRequestMatcher("/register")).permitAll()
                                        .requestMatchers(new AntPathRequestMatcher("/hotel/search")).permitAll()
                                        .requestMatchers(new AntPathRequestMatcher("/transport/search")).permitAll()
                                        .requestMatchers(new AntPathRequestMatcher("/restaurant/search")).permitAll()
                                        .requestMatchers(new AntPathRequestMatcher("/upload")).permitAll()
                                        .requestMatchers(new AntPathRequestMatcher("/business/approve/*")).hasAnyAuthority("SUPERADMIN")
                                        .requestMatchers(new AntPathRequestMatcher("/users/unlock/*")).hasAnyAuthority("SUPERADMIN")
                                        .requestMatchers(new AntPathRequestMatcher("/users/approve/*")).hasAnyAuthority("SUPERADMIN")
                                        .requestMatchers(new AntPathRequestMatcher("/business/unapproved")).hasAnyAuthority("SUPERADMIN")
                                        .requestMatchers(new AntPathRequestMatcher("/business/add/*")).authenticated()
                                        .requestMatchers(new AntPathRequestMatcher("/*/user/{userId}")).access(userSecurity)
//                                        .anyRequest().permitAll()
                                        .anyRequest().authenticated()
                                        .and()
                                        .oauth2Login()
                                        .loginPage("/login")
                                        .permitAll()
                                        .userInfoEndpoint(x -> x.userService(customOAuth2UserDetailService))
//                                        .userService(customOAuth2UserDetailService)
                                        .successHandler(oAuth2SuccessHandler)
                                        .failureHandler(oAuth2FailureHandler)
                                        .and()
                                        .formLogin()
                                        .loginPage("/login")
                                        .successHandler(oAuth2SuccessHandler)
                                        .permitAll()
                                        .permitAll()
                                        .and()
                                        .sessionManagement()
                                        .sessionCreationPolicy(SessionCreationPolicy.ALWAYS)
                                        .and()
                                        .logout().logoutSuccessHandler((new HttpStatusReturningLogoutSuccessHandler(HttpStatus.OK)))
                                        .permitAll();

                            } catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                ).httpBasic();
        return http.build();
    }
}
