package com.tourMate.config;

import com.tourMate.config.oauth2.CustomOAuth2UserDetailService;
import com.tourMate.config.oauth2.OAuth2UserDetailsCustom;
import com.tourMate.entities.Hotels;
import com.tourMate.entities.User;
import com.tourMate.services.HotelManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.stereotype.Component;

import java.util.function.Supplier;

@Component
public class UserSecurity implements AuthorizationManager<RequestAuthorizationContext> {

    @Override
    public AuthorizationDecision check(Supplier authenticationSupplier, RequestAuthorizationContext ctx) {
        Long userId = Long.parseLong(ctx.getVariables().get("userId"));
        Authentication authentication = (Authentication) authenticationSupplier.get();
        return new AuthorizationDecision(hasUserId(authentication, userId));
    }

    public boolean hasUserId(Authentication authentication, Long userId) {
        System.out.println(userId);
        Long id;
        if(authentication.getPrincipal() instanceof OAuth2UserDetailsCustom oAuth2UserDetailsCustom)
        {
            id = oAuth2UserDetailsCustom.getId();
        }
        else
        {
            User user = (User) authentication.getPrincipal();
            id = user.getUserID();
        }
        return userId == id;
    }

}
