package com.tourMate.config.oauth2;

import com.tourMate.dao.UsersDao;
import com.tourMate.entities.Role;
import com.tourMate.entities.User;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.Objects;

@Service
public class CustomOAuth2UserDetailService extends DefaultOAuth2UserService {

    private final UsersDao usersDao;

    public CustomOAuth2UserDetailService(UsersDao usersDao) {
        this.usersDao = usersDao;
    }

    @Override
    public OAuth2User loadUser(OAuth2UserRequest userRequest) throws OAuth2AuthenticationException {
        OAuth2User oAuth2User = super.loadUser(userRequest);

        try
        {
            return checkOAuth2User(userRequest, oAuth2User);
        }
        catch (AuthenticationException e)
        {
            throw e;
        }
        catch (Exception ex)
        {
            throw ex;
            //throw new InternalAuthenticationServiceException(ex.getMessage(), ex.getCause());
        }
    }

    private OAuth2User checkOAuth2User(OAuth2UserRequest oAuth2UserRequest, OAuth2User oAuth2User)
    {
        OAuth2UserDetails oAuth2UserDetails = OAuth2UserDetailsFactory
                .createOAuth2UserDetails(oAuth2UserRequest.getClientRegistration().getRegistrationId(), oAuth2User.getAttributes());

        if(ObjectUtils.isEmpty(oAuth2UserRequest))
        {
            throw new RuntimeException("Cannot identifty OAuth2 user!");
        }

        User user = usersDao.findByUsernameAndProvider(
                oAuth2UserDetails.getEmail(),
                oAuth2UserRequest.getClientRegistration().getRegistrationId());
        User userDetails = null;
        if(user != null)
        {
            userDetails = user;
            userDetails = updateOAuth2UserDetail(userDetails, oAuth2UserDetails);
        }
        else
        {
            userDetails = registerOAuth2UserDetail(oAuth2UserRequest, oAuth2UserDetails);
        }
        return new OAuth2UserDetailsCustom(
                userDetails.getUserID(),
                userDetails.getUsername(),
                userDetails.getPassword(),
                Collections.singletonList(new SimpleGrantedAuthority(userDetails.getRole().getRoleName()))
        );
    }

    public User registerOAuth2UserDetail(OAuth2UserRequest oAuth2UserRequest, OAuth2UserDetails oAuth2UserDetails)
    {
        Role r = usersDao.findById(1L);
        User user = new User();
        user.setName(Objects.requireNonNullElse(oAuth2UserDetails.getName(), ""));
        user.setEmail(oAuth2UserDetails.getEmail());
        user.setProvider(oAuth2UserRequest.getClientRegistration().getRegistrationId());
        user.setRole(r);
        return usersDao.updateUser(user);
    }

    public User updateOAuth2UserDetail(User user, OAuth2UserDetails oAuth2UserDetails)
    {
        user.setEmail(oAuth2UserDetails.getEmail());
        return usersDao.mergeUser(user);
    }
}
