package com.tourMate.controllers;

import com.tourMate.dao.ReviewManager;
import com.tourMate.entities.Reviews;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@CrossOrigin
public class ReviewController {
    @Autowired
    ReviewManager reviewManager;

    @PostMapping(path = "/review/add")
    public void add(@RequestParam(name = "title") String title,
                    @RequestParam(name = "numStars") Integer numStars,
                    @RequestParam(name = "description") String description,
                    @RequestParam(name = "hotelId", required = false) Long hotelId,
                    @RequestParam(name = "restaurantId", required = false) Long restaurantId,
                    @RequestParam(name = "transportId", required = false) Long transportId,
                    @RequestParam(name = "reservationId") Long reservationId) {
        reviewManager.createReview(title, numStars, description, hotelId, restaurantId, transportId, reservationId);
    }

    @PostMapping(path = "/review/edit")
    public void edit(@RequestBody Reviews review)
    {
        reviewManager.editReview(review.getReviewId(), review.getTitle(), review.getDescription(), review.getNumStar(), review.getHotel(), review.getRestaurant(), review.getTransport());
    }

    @GetMapping(path = "/review/delete")
    public ResponseEntity remove(@RequestParam(name = "reviewId") long reviewId) {
        try
        {
            reviewManager.deleteReview(reviewId);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception exception)
        {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }


}
