package com.tourMate.dao;

import com.tourMate.entities.Providers;
import com.tourMate.entities.Role;
import com.tourMate.entities.User;
import jakarta.transaction.Transactional;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.Date;
import java.util.List;

public interface UsersDao {

    public void createUser(String name, String surname, String email, Date birthDate, String address, String contact);

    public void deleteUser(long userID);

    public List<User> getCreatedUsers();

    public List<Role> getRoles();

    public User findUserByID(long userID);

    public void editUser(long userID, String name, String surname, String email, Date birthDate, String address, String contact);

    UserDetails findUserByUsername(String username);

    List<User> getUnapprovedUsers();

    void approveUserProfile(User u);

    Role findById(Long id);
    User updateUser(User s);
    User findByUsernameAndProvider(String username, String providers);

    @Transactional
    User mergeUser(User user);

    List<User> getAdmins();

    List<User> findConnectedAccountsByUser(User u);
}
