package com.tourMate.dao.impl;

import com.tourMate.dao.TransportDao;
import com.tourMate.entities.*;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class TransportDaoImpl implements TransportDao {

    @PersistenceContext
    private EntityManager em;

    @Override
    @Transactional
    public void createTransport(Transport t) {
        em.persist(t);
    }

    @Override
    @Transactional
    public void deleteTransport(Transport t) {
        em.remove(t);
    }

    @Override
    public List<Transport> getTransports() {
        return em.createQuery("from Transport order by transportID").getResultList();
    }

    @Override
    public List<Transport> getTransportsByUser(User u) {
        List<Transport> transports = em.createQuery("select t from Transport t where t.owner = :u or t.owner in :users")
                .setParameter("u", u)
                .setParameter("users", u.getConnectedAccounts())
                .getResultList();
        return transports;
    }

    @Override
    public List<TransportAvailible> getRoutesForTransport(Transport t) {
        List<TransportAvailible> transportsAvailible = em.createQuery("select ta from TransportAvailible ta where ta.transport = :transport").setParameter("transport", t).getResultList();
        return transportsAvailible;
    }

    @Override
    public Transport findTransportById(long transportId) {
        Transport x = em.find(Transport.class,transportId);
        return x;
    }

    @Override
    public Transport getTransportById(long transportId)
    {
        return em.find(Transport.class, transportId);
    }

    @Override
    @Transactional
    public void editTransport(Transport t) {
        em.persist(t);
    }

    @Override
    @Transactional
    public void createTransportReservation(TransportReservation transportReservation) {
        em.persist(transportReservation);
    }

    @Override
    public TransportReservation findTransportReservationByID(long reservationID) {
        return em.find(TransportReservation.class,reservationID);
    }

    @Override
    public List<TransportReservation> getTransportReservations() {
        return em.createQuery("from TransportReservation order by reservationID").getResultList();
    }

    @Override
    public TransportAvailible findTransportAvailableByID(long reservationID) {
        return em.find(TransportAvailible.class,reservationID);
    }

    @Override
    public List<TransportRoute> getTransportsAvailableByFilters(String fromL, String toL, Date date, int numPassengers) {
        System.out.println(fromL + " " + toL);
        return em.createQuery("select h from TransportRoute h where h.from = :froml and h.to = :tol and h.freeSpace >= :nump")
                .setParameter("froml", fromL)
                .setParameter("tol", toL)
                .setParameter("nump", numPassengers)
                .getResultList();
    }

    @Override
    public List<TransportReservation> getTransportsReservationsByUserID(long userID) {
        return null;
    }

    @Override
    public List<TransportAvailible> getTransportsAvailable() {
        return em.createQuery("from TransportAvailible order by transportAvailibleId").getResultList();
    }

    @Override
    @Transactional
    public void createTransportAvailable(TransportAvailible ta) {
        em.persist(ta);

    }

    @Override
    public void editTransportAvailable(TransportAvailible ta) {
        em.persist(ta);
    }

    @Override
    public TransportRoute findTransportRouteById(long transportRouteId){
        return em.find(TransportRoute.class, transportRouteId);
    }

    @Override
    public List<Reviews> getReviewsForTransport(Transport transport) {
        return em.createQuery("select r from Reviews r where r.transport = :transport")
                .setParameter("transport", transport)
                .getResultList();
    }

    @Override
    public List<TransportReservation> findPastReservationByUser(User user) {
        return em.createQuery("SELECT r from TransportReservation r where r.user = :user and r.transportRoute.arrival <= now()")
                .setParameter("user", user)
                .getResultList();

    }

    @Transactional
    @Override
    public void saveReservation(TransportReservation transportReservation) {
        em.persist(transportReservation);
    }

    @Override
    public List<TransportReservation> findReservationByUser(User user) {
        return em.createQuery("SELECT r from TransportReservation r where r.user = :user and r.transportRoute.arrival >= now()")
                .setParameter("user", user)
                .getResultList();

    }


    @Override
    @Transactional
    public void deleteTransportReservation(TransportReservation tr) {
        em.remove(tr);
    }

    @Override
    @Transactional
    public void deleteTransportAvailable(TransportAvailible ta) {
        em.remove(ta);
    }

    @Override
    @Transactional
    public void createTransportRoute(TransportRoute tr) {
        em.persist(tr);
    }

    @Override
    public void deleteTransportRoute(TransportRoute tr) {
        em.remove(tr);
    }

    @Override
    public void editTransportRoute(TransportRoute tr) {
        em.persist(tr);

    }

    @Override
    public List<TransportReservation> findTransportReservationByTransportId(Transport t) {
        return em.createQuery("SELECT tr from TransportReservation tr where tr.transportRoute.parentRoute.transport= :transport")
                .setParameter("transport", t)
                .getResultList();
    }


}
