package com.tourMate.events;

import com.tourMate.entities.User;
import org.springframework.context.ApplicationEvent;

public abstract class EmailEvent extends ApplicationEvent {
    protected EventType eventType;
    protected User user;
    protected String subject;
    protected String message;

    public EmailEvent(User user) {
        super(user);
        this.user = user;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public EventType getEventType() {
        return eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
