package com.tourMate.events;

import com.tourMate.entities.HotelRoomReservations;
import com.tourMate.entities.User;

import java.text.SimpleDateFormat;

public class OnHotelReservationEvent extends EmailEvent{
    private HotelRoomReservations hotelRoomReservations;
    public OnHotelReservationEvent(User u, HotelRoomReservations hotelRoomReservations) {
        super(u);
        this.hotelRoomReservations = hotelRoomReservations;
        this.eventType = EventType.HOTEL_RESERVATION;
        this.subject = "TourMate - Потврда за резервација - " + hotelRoomReservations.getHotelRoom().getHotel().getHotelName();
        this.message = String.format("Драг кориснику,\n\nВе известуваме дека Вашата резервација за %s е потврдена\n\n" +
                        "Детали за резервацијата:\n" +
                        "%s - %s" +
                        "\n%s" +
                        "\n\n\nСо почит,\nTourMate", hotelRoomReservations.getHotelRoom().getHotel().getHotelName()
                , new SimpleDateFormat("dd-MM-yyyy").format(hotelRoomReservations.getDateFrom())
                , new SimpleDateFormat("dd-MM-yyyy").format(hotelRoomReservations.getDateTo())
                , hotelRoomReservations.getHotelRoom().getHotelRoomName());
    }

    public HotelRoomReservations getHotelRoomReservations() {
        return hotelRoomReservations;
    }

    public void setHotelRoomReservations(HotelRoomReservations hotelRoomReservations) {
        this.hotelRoomReservations = hotelRoomReservations;
    }
}
