package com.tourMate.events;

import com.tourMate.entities.User;
import lombok.Data;
import org.springframework.context.ApplicationEvent;

public class OnRegistrationSuccessEvent extends EmailEvent {
    private static final long serialVersionUID = 1L;
    private User user;

    public OnRegistrationSuccessEvent(User user) {
        super(user);
        this.eventType = EventType.REGISTRATION;
        this.subject = "TourMate - Успешна регистрација";
        this.message = "Драг кориснику,\n\nВе известуваме дека Вашата регистрација на апликацијата TourMate е успешна. За да можете да го користите профилот, потребно е истиот да е одобрен од страна на администраторот за што ќе добиете дополнителна потврда на оваа адреса.\n\n\nСо почит,\nTourMate";
    }
}