package com.tourMate.listeners;

import com.tourMate.entities.User;
import com.tourMate.events.*;
import com.tourMate.services.MailingService;
import com.tourMate.services.UsersManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;

@Component
public class RegistrationEmailListener implements ApplicationListener<EmailEvent> {

    @Autowired
    private Environment environment;
    @Autowired
    private MailingService mailingService;


    @Override
    public void onApplicationEvent(EmailEvent event) {
        mailingService.sendMail(event.getUser().getEmail(), event.getSubject(), event.getMessage());
    }
}