package com.tourMate.services;

import com.tourMate.dto.RestaurantDto;
import com.tourMate.dto.RestaurantReservationDto;
import com.tourMate.dto.RestaurantReservationUserDto;
import com.tourMate.entities.*;

import java.util.Date;
import java.util.List;

public interface RestaurantManager {
    public void createRestaurant(Restaurant restaurant, long userId);

    public void addMenuToRestaurant(long restaurantId, Menu menu);

    public List<Restaurant> getRestaurantsByUser(long userId);
    public void deleteRestaurant(Long restaurantID);

    void deleteRestaurant(long restaurantID);

    public List<Restaurant> getRestaurants();

    public Restaurant findRestaurantByID(long restaurantID);

    public void addRestaurantImage(Long restaurant, List<String> url);

    public void removeRestaurantImage(long restaurantImageId);

    public RestaurantImages findRestaurantImageById(long restaurantImageId);

    public List<RestaurantImages> getRestaurantImages(long restaurantID);

    public void editRestaurant(long restaurantID, String restaurantName, String restaurantLocation, String cousineType, String restaurantDescription, String restaurantEdbs, User restaurantOwner);

    void editReservation(long restaurantsTableId, RestaurantsTable rt, Date hourFrom, Date hourTo, int noSeats, User user);

    public List<RestaurantsTable> getRestaurantTables(long restaurantID);

    public List<RestaurantDto> getTablesByDateAndLocation(String restaurantLocation, Date date, String hourFrom, String hourTo, int noSeats);

    public RestaurantsTable findTableById(long tableId);

    public void createTable(Long restaurantId, int noSeats);

    public void editTable(Restaurant restaurant, long tableId, int noSeats);

    public void deleteTable(long tableId);

    public void createTableAvailable(Long rt, Date hourFrom, Date hourTo, int numTables);

    public void editTableAvailable(long tableId, Restaurant restaurant, int noSeats);

    public void deleteTableAvailable(long tableId);

    public List<RestaurantsAvailible> getTablesAvailabilityById(Long id);

    RestaurantsAvailible findAvailableReservationByID(long tableId);

    void createReservation(RestaurantsTable rt, Date dateFrom, Date dateTo, User user);

    public void deleteReservation(long tableId);

    public RestaurantReservations findReservationByID(long tableId);

//    List<RestaurantReservations> findAvailableReservationByID(long reservationId);

    public List<RestaurantReservations> findReservationByUser(User user);

    public List<RestaurantReservationDto> findReservationByRestaurant(Long restaurant);

    public List<RestaurantReservations> getReservations();

    public List<Restaurant> searchByRestaurantName(String restaurantName);

    public List<Restaurant> searchByRestaurantLocation(String restaurantLocation);

    public List<RestaurantsTable> searchByNoSeats(int noSeats);

    List<Reviews> getReviewsForRestaurant(Long restaurantId);

    void createReservation(Long userId, Long restaurantTableId, Long restaurantAvailibleId, String hourFrom, String hourTo, Date date);

    List<RestaurantReservationUserDto> findValidRestaurantReservationsByUser(Long userId);

    List<RestaurantReservationUserDto> findPastRestaurantReservationsByUser(Long userId);

    List<MenuImages> getMenuImages(Long id);

    void addMenuImage(Long restaurant, List<String> url);

    Menu findMenuById(Long menuId);

    void setReservationReviewed(Long reservationId);

    List<MenuImages> getMenuImagesByRestaurant(long restaurantId);
}
