package com.tourMate.services.impl;

import com.tourMate.dao.UsersDao;
import com.tourMate.dto.PrincipalInfo;
import com.tourMate.entities.User;
import com.tourMate.events.OnProfileEnabledEvent;
import com.tourMate.services.UsersManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class UsersManagerImpl implements UsersManager, UserDetailsService {

    @Autowired
    UsersDao usersDao;
    @Autowired
    ApplicationEventPublisher eventPublisher;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Override
    public void createUser(String name, String surname, String email, Date birthDate, String address, String contact) {
        usersDao.createUser(name, surname, email, birthDate, address, contact);
    }

    @Override
    public void deleteUser(long userID) {
        usersDao.deleteUser(userID);
    }

    @Override
    public List<User> getCreatedUsers() {
        return usersDao.getCreatedUsers();
    }

    @Override
    public User findUserByID(long userID) {
        return usersDao.findUserByID(userID);
    }

    @Override
    public void editUser(long userID, String name, String surname, String email, Date birthDate, String address, String contact) {
        usersDao.editUser(userID, name, surname, email, birthDate, address, contact);
    }

    @Override
    public List<User> getUnapprovedUsers() {
        return usersDao.getUnapprovedUsers();
    }

    @Override
    public void approveUserProfile(long userId) {
        User u = findUserByID(userId);
        usersDao.approveUserProfile(u);
    }

    @Override
    public void unlock(Long id) {
        User u = findUserByID(id);
        u.setLocked(!u.isLocked());
        u.setEnabled(true);
        usersDao.updateUser(u);
    }

    @Override
    public List<User> getAdmins() {
        return usersDao.getAdmins();
    }

    @Override
    public void connectAccount(Long id, String username, String password) {
        User u1 = findUserByID(id);
        User u2 = (User) loadUserByUsername(username);
        if(passwordEncoder.matches(password, u2.getPassword()))
        {
            u1.addConnectedUser(u2);
        }
        usersDao.updateUser(u1);
    }

    @Override
    public List<User> findConnectedAccountsByUser(Long id) {
        User u = findUserByID(id);
        return usersDao.findConnectedAccountsByUser(u);
    }

    @Override
    public PrincipalInfo getPrincipalInfo(Long userId) {
        PrincipalInfo principalInfo = new PrincipalInfo();
        User u = findUserByID(userId);
        principalInfo.setUsername(u.getUsername());
        principalInfo.setRole(u.getRole().getRoleName());
        principalInfo.setId(userId);
        principalInfo.setName(u.getName());
        principalInfo.setEmail(u.getEmail());
        principalInfo.setSurname(u.getSurname());
        return principalInfo;
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return usersDao.findUserByUsername(username);
    }
}
