import useGet from "../Hooks/useGet";
import useApprove from "../Hooks/useApprove";
import {Container} from "react-bootstrap";
import {FaCheckCircle} from "react-icons/fa";
import React from "react";
import {useAuth} from "../Context/AuthContext";
import profilePage from "../../Pages/ProfilePage";

const ConnectedAccountsTable = (props) => {

    const data = props.data;
    const isLoading = props.isLoading;

    const { getData: approveBusiness} = useApprove();

    return (
        <>
            <Container fluid >
                <table className="table table-hover">
                    <thead>
                    <tr>
                        <th scope="col">Ред. бр.</th>
                        <th scope="col">User ID</th>
                        <th scope="col">Име</th>
                        <th scope="col">Презиме</th>
                        <th scope="col">Username</th>
                        <th>Дисконектирај</th>
                    </tr>
                    </thead>
                    <tbody>
                    {data.map((f, i) => { return <tr key={f.userID}>
                        <th style={{verticalAlign: "middle"}} scope="row">{i + 1}</th>
                        <td style={{verticalAlign: "middle"}}>{f.userID}</td>
                        <td style={{verticalAlign: "middle"}}>{f.name}</td>
                        <td style={{verticalAlign: "middle"}}>{f.surname}</td>
                        <td style={{verticalAlign: "middle"}}>{f.username}</td>
                        <td style={{verticalAlign: "middle"}}><FaCheckCircle size={'2.2em'} color={'#159895'} onClick={() => {
                        }}/></td>
                    </tr>})}
                    </tbody>
                </table>
            </Container>
        </>
    )
}

export default ConnectedAccountsTable;