import React from 'react'
import { Navigate } from 'react-router-dom'
import {useAuth} from "../Context/AuthContext";

function PrivateRoute({ children }) {
  const { userIsAuthenticated } = useAuth()
  if(userIsAuthenticated())
  {
    return children;
  }
  else
  {
    window.location.href = "http://localhost:8080/login";
  }
  return userIsAuthenticated() ? children : <Navigate to="http://localhost:8080/login" />
}

export default PrivateRoute