package com.tourMate.config.oauth2;

import com.tourMate.entities.Providers;

import java.util.Map;

public class OAuth2UserDetailsFactory {
    public static OAuth2UserDetails createOAuth2UserDetails (String registrationId, Map<String, Object> attributes)
    {
        if(registrationId.equals(Providers.google.name()))
        {
            return new OAuth2GoogleUser(attributes);
        }
        else if(registrationId.equals(Providers.facebook.name()))
        {
            return new OAuth2FacebookUser(attributes);
        }
        else if(registrationId.equals(Providers.github.name()))
        {
            return new OAuth2GitHubUser(attributes);
        }
        else
        {
            throw  new RuntimeException("Login with this provider is not supported!");
        }
    }
}
