package com.tourMate.dao;

import com.tourMate.entities.*;
import jakarta.transaction.Transactional;


import java.util.Date;
import java.util.List;

public interface TransportDao {
    @Transactional
    void createTransport(Transport t);

    @Transactional
    void deleteTransport(Transport t);

    List<Transport> getTransports();

    List<Transport> getTransportsByUser(User u);

    List<TransportAvailible> getRoutesForTransport(Transport t);

    Transport findTransportById(long transportId);

    Transport getTransportById(long transportId);

    @Transactional
    void editTransport(Transport t);

    @Transactional
    void createTransportReservation(TransportReservation transportReservation);

    TransportReservation findTransportReservationByID(long reservationID);

    List<TransportReservation> getTransportReservations();

    TransportAvailible findTransportAvailableByID(long reservationID);

    List<TransportRoute> getTransportsAvailableByFilters(String fromL, String toL, Date date, int numPassengers);

    List<TransportReservation> getTransportsReservationsByUserID(long userID);

    List<TransportAvailible> getTransportsAvailable();

    @Transactional
    void createTransportAvailable(TransportAvailible ta);

    void editTransportAvailable(TransportAvailible ta);

    TransportRoute findTransportRouteById(long transportRouteId);

    List<Reviews> getReviewsForTransport(Transport transport);

    List<TransportReservation> findPastReservationByUser(User user);

    @Transactional
    void saveReservation(TransportReservation transportReservation);

    List<TransportReservation> findReservationByUser(User user);

    @Transactional
    void deleteTransportReservation(TransportReservation tr);

    @Transactional
    void deleteTransportAvailable(TransportAvailible ta);

    void createTransportRoute(TransportRoute tr);

    void deleteTransportRoute(TransportRoute tr);

    void editTransportRoute(TransportRoute tr);

    List<TransportReservation> findTransportReservationByTransportId(Transport t);

//    public void createTransport(String transportName, String carBrand, String carType, int carManufacturedYear, int noPassengers, int noBags, long EMBG, Long userId, String carPlate);
//
//    public void deleteTransport(long transportId);
//
//    public void editTransport(long transportID, String transportName, String carBrand, String carType, int carManufacturedYear, int noPassengers, int noBags, long EMBG, User owner, String carPlate);
//
//    public List<Transport> getTransports();
//    public List<TransportDto> getTransportsByUser(long userId);
//
//    public List<RouteListingDto> getRoutesForTransport(long transportId);
//    public Transport getTransportById(long transportId);
//    public TransportDto findTransportById (long transportId);
//
//    public void createTransportReservation(TransportReservation transportReservation);
//
//    public void editTransportReservation(Transport transport, long reservationID, String departureLocation, String arrivalLocation, Date date, Integer noSeats, User user, Date departureHour);
//
//    public void deleteTransportReservation(long reservationID);
//
//    public TransportReservation findTransportReservationByID(long reservationID);
//
//    public List<TransportReservation> getTransportReservations();
//
//    public List<TransportReservation> getTransportsReservationsByUserID(long userID);
//
//    public void createTransportAvailable(Transport transport, String departureLocation, String arrivalLocation, Date date, Integer noSeats, Date departureHour, Collection<TransportRoute> routes);
//
//    public void editTransportAvailable(Transport transport, long availableID, String departureLocation, String arrivalLocation, Date date, Integer noSeats, Date departureHour);
//
//    public void deleteTransportAvailable(long availableID);
//
//    public TransportAvailible findTransportAvailableByID (long reservationID);
//
//    public List<TransportAvailible> getTransportsAvailable();
//
//    public List<TransportRoute> getTransportsAvailableByFilters (String from, String to, Date date, int numPassengers);
//
//    public void createTransportRoute(TransportAvailible parentRoute, String from, String to, double price, Date departure, Date arrival, int freeSpace, int order);
//
//    public void deleteTransportRoute(long transportRouteId);
//
//    public void editTransportRoute(long transportRouteId, TransportAvailible parentRoute, String from, String to, double price, Date departure, Date arrival, int freeSpace, int order);
//
//    public TransportRoute findTransportRouteById(long transportRouteId);
//
//    List<Reviews> getReviewsForTransport(Transport transport);
//
//    List<TransportReservation> findReservationByUser(User u);
//
//    List<TransportReservation> findPastReservationByUser(User user);
//
//    void saveReservation(TransportReservation transportReservation);
}
