package com.tourMate.events;

import com.tourMate.entities.RestaurantReservations;
import com.tourMate.entities.TransportReservation;
import com.tourMate.entities.User;

import java.text.SimpleDateFormat;

public class OnRestaurantReservationEvent extends EmailEvent {
    private RestaurantReservations restaurantReservations;
    public OnRestaurantReservationEvent(User u, RestaurantReservations restaurantReservations) {
        super(u);
        this.restaurantReservations = restaurantReservations;
        this.eventType = EventType.RESTAURANT_RESERVATION;
        this.subject = "TourMate - Потврда за резервација - " + restaurantReservations.getTable().getRestaurant().getRestaurantName();
        this.message = String.format("Драг кориснику,\n\nВе известуваме дека Вашата резервација за %s е потврдена\n\n" +
                        "Детали за резервацијата:\n" +
                        "%s - %s" +
                        "\nМаса за %s луѓе" +
                        "\n\n\nСо почит,\nTourMate", restaurantReservations.getTable().getRestaurant().getRestaurantName()
                , new SimpleDateFormat("dd-MM-yyyy hh:mm").format(restaurantReservations.getTimeFrom())
                , new SimpleDateFormat("dd-MM-yyyy hh:mm").format(restaurantReservations.getTimeTo())
                , restaurantReservations.getTable().getNoSeats());

    }

    public RestaurantReservations getRestaurantReservations() {
        return restaurantReservations;
    }

    public void setRestaurantReservations(RestaurantReservations restaurantReservations) {
        this.restaurantReservations = restaurantReservations;
    }
}
