package com.tourMate.events;

import com.tourMate.entities.HotelRoomReservations;
import com.tourMate.entities.TransportReservation;
import com.tourMate.entities.User;

public class OnTransportReservationEvent extends EmailEvent {
    private TransportReservation transportReservation;
    public OnTransportReservationEvent(User u, TransportReservation transportReservation) {
        super(u);
        this.transportReservation = transportReservation;
        this.eventType = EventType.HOTEL_RESERVATION;

        this.subject = "TourMate - Потврда за резервација за рута " + transportReservation.getTransportRoute().getFrom() + " " + transportReservation.getTransportRoute().getTo();
        this.message = String.format("Драг кориснику,\n\nВе известуваме дека Вашата резервација за патувањето %s е потврдена\n\n" +
                        "Детали за резервацијата:\n" +
                        "%s - %s" +
                        "\n\n\nСо почит,\nTourMate", transportReservation.getTransportRoute().getFrom() + " " + transportReservation.getTransportRoute().getTo()
                , transportReservation.getTransportRoute().getDeparture()
                , transportReservation.getTransportRoute().getArrival());
    }

    public TransportReservation getTransportReservation() {
        return transportReservation;
    }

    public void setTransportReservation(TransportReservation transportReservation) {
        this.transportReservation = transportReservation;
    }
}
